/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SiddhiTestHelper {
    private SiddhiTestHelper() {
    }

    public static void waitForEvents(long sleepTime, AtomicBoolean condition, long timeout) throws InterruptedException {
        long currentWaitTime = 0L;
        long startTime = System.currentTimeMillis();
        while (!condition.get() && currentWaitTime <= timeout) {
            Thread.sleep(sleepTime);
            currentWaitTime = System.currentTimeMillis() - startTime;
        }
    }

    public static void waitForEvents(long sleepTime, int expectedCount, AtomicInteger actualCount, long timeout) throws InterruptedException {
        long currentWaitTime = 0L;
        long startTime = System.currentTimeMillis();
        while (actualCount.get() < expectedCount && currentWaitTime <= timeout) {
            Thread.sleep(sleepTime);
            currentWaitTime = System.currentTimeMillis() - startTime;
        }
    }

    public static void waitForEvents(long sleepTime, int expectedSize, Collection<?> collection, long timeout) throws InterruptedException {
        long currentWaitTime = 0L;
        long startTime = System.currentTimeMillis();
        while (collection.size() < expectedSize && currentWaitTime <= timeout) {
            Thread.sleep(sleepTime);
            currentWaitTime = System.currentTimeMillis() - startTime;
        }
    }

    public static boolean isEventsMatch(List<Object[]> actual, List<Object[]> expected) {
        if (actual.size() != expected.size()) {
            return false;
        }
        for (int i = 0; i < actual.size(); ++i) {
            if (Arrays.equals(actual.get(i), expected.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnsortedEventsMatch(List<Object[]> actual, List<Object[]> expected) {
        if (actual.size() != expected.size()) {
            return false;
        }
        for (int i = 0; i < actual.size(); ++i) {
            boolean isThere = false;
            for (int j = 0; j < expected.size(); ++j) {
                if (!Arrays.equals(actual.get(i), expected.get(j))) continue;
                isThere = true;
                break;
            }
            if (isThere) continue;
            return false;
        }
        return true;
    }
}

