/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.Map;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

public abstract class AttributeAggregator {
    protected ExpressionExecutor[] attributeExpressionExecutors;
    protected SiddhiAppContext siddhiAppContext;
    private int attributeSize;
    private String queryName;
    private ConfigReader configReader;

    public void initAggregator(ExpressionExecutor[] attributeExpressionExecutors, SiddhiAppContext siddhiAppContext, String queryName, ConfigReader configReader) {
        this.queryName = queryName;
        this.configReader = configReader;
        try {
            this.siddhiAppContext = siddhiAppContext;
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.attributeSize = attributeExpressionExecutors.length;
            this.init(attributeExpressionExecutors, configReader, siddhiAppContext);
        }
        catch (Throwable t) {
            throw new SiddhiAppCreationException(t);
        }
    }

    public AttributeAggregator cloneAggregator(String key) {
        try {
            AttributeAggregator attributeAggregator = (AttributeAggregator)this.getClass().newInstance();
            ExpressionExecutor[] innerExpressionExecutors = new ExpressionExecutor[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                innerExpressionExecutors[i] = this.attributeExpressionExecutors[i].cloneExecutor(key);
            }
            attributeAggregator.initAggregator(innerExpressionExecutors, this.siddhiAppContext, this.queryName, this.configReader);
            return attributeAggregator;
        }
        catch (Exception e) {
            throw new SiddhiAppRuntimeException("Exception in cloning " + this.getClass().getCanonicalName(), e);
        }
    }

    public synchronized Object process(ComplexEvent event) {
        if (this.attributeSize > 1) {
            Object[] data = new Object[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                data[i] = this.attributeExpressionExecutors[i].execute(event);
            }
            switch (event.getType()) {
                case CURRENT: {
                    return this.processAdd(data);
                }
                case EXPIRED: {
                    return this.processRemove(data);
                }
                case RESET: {
                    return this.reset();
                }
            }
        } else if (this.attributeSize == 1) {
            switch (event.getType()) {
                case CURRENT: {
                    return this.processAdd(this.attributeExpressionExecutors[0].execute(event));
                }
                case EXPIRED: {
                    return this.processRemove(this.attributeExpressionExecutors[0].execute(event));
                }
                case RESET: {
                    return this.reset();
                }
            }
        } else {
            switch (event.getType()) {
                case CURRENT: {
                    return this.processAdd(null);
                }
                case EXPIRED: {
                    return this.processRemove(null);
                }
                case RESET: {
                    return this.reset();
                }
            }
        }
        return null;
    }

    protected abstract void init(ExpressionExecutor[] var1, ConfigReader var2, SiddhiAppContext var3);

    public abstract Attribute.Type getReturnType();

    public abstract Object processAdd(Object var1);

    public abstract Object processAdd(Object[] var1);

    public abstract Object processRemove(Object var1);

    public abstract Object processRemove(Object[] var1);

    public abstract boolean canDestroy();

    public abstract Object reset();

    public abstract Map<String, Object> currentState();

    public abstract void restoreState(Map<String, Object> var1);

    public void clean() {
        for (ExpressionExecutor expressionExecutor : this.attributeExpressionExecutors) {
            expressionExecutor.clean();
        }
    }
}

