/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.partition;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverterFactory;
import org.wso2.siddhi.core.partition.PartitionRuntime;
import org.wso2.siddhi.core.partition.executor.PartitionExecutor;
import org.wso2.siddhi.core.query.QueryRuntime;
import org.wso2.siddhi.core.query.input.stream.StreamRuntime;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class PartitionStreamReceiver
implements StreamJunction.Receiver {
    private final StreamEventPool eventPool;
    private StreamEventConverter streamEventConverter;
    private String streamId;
    private MetaStreamEvent metaStreamEvent;
    private StreamDefinition streamDefinition;
    private SiddhiAppContext siddhiAppContext;
    private PartitionRuntime partitionRuntime;
    private List<PartitionExecutor> partitionExecutors;
    private Map<String, StreamJunction> cachedStreamJunctionMap = new ConcurrentHashMap<String, StreamJunction>();

    public PartitionStreamReceiver(SiddhiAppContext siddhiAppContext, MetaStreamEvent metaStreamEvent, StreamDefinition streamDefinition, List<PartitionExecutor> partitionExecutors, PartitionRuntime partitionRuntime) {
        this.metaStreamEvent = metaStreamEvent;
        this.streamDefinition = streamDefinition;
        this.partitionRuntime = partitionRuntime;
        this.partitionExecutors = partitionExecutors;
        this.siddhiAppContext = siddhiAppContext;
        this.streamId = streamDefinition.getId();
        this.eventPool = new StreamEventPool(metaStreamEvent, 5);
    }

    public void init() {
        this.streamEventConverter = StreamEventConverterFactory.constructEventConverter(this.metaStreamEvent);
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public void receive(ComplexEvent complexEvent) {
        if (this.partitionExecutors.size() == 0) {
            ComplexEventChunk<StreamEvent> outputEventChunk = new ComplexEventChunk<StreamEvent>(false);
            for (ComplexEvent aComplexEvent = complexEvent; aComplexEvent != null; aComplexEvent = aComplexEvent.getNext()) {
                StreamEvent borrowedEvent = this.borrowEvent();
                this.streamEventConverter.convertComplexEvent(aComplexEvent, borrowedEvent);
                outputEventChunk.add(borrowedEvent);
            }
            this.send((ComplexEvent)outputEventChunk.getFirst());
        } else if (complexEvent.getNext() == null) {
            for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
                StreamEvent borrowedEvent = this.borrowEvent();
                this.streamEventConverter.convertComplexEvent(complexEvent, borrowedEvent);
                String key = partitionExecutor.execute(borrowedEvent);
                this.send(key, borrowedEvent);
            }
        } else {
            ComplexEventChunk<ComplexEvent> complexEventChunk = new ComplexEventChunk<ComplexEvent>(false);
            complexEventChunk.add(complexEvent);
            ComplexEventChunk<StreamEvent> outputEventChunk = new ComplexEventChunk<StreamEvent>(false);
            String currentKey = null;
            while (complexEventChunk.hasNext()) {
                Object aEvent = complexEventChunk.next();
                complexEventChunk.remove();
                StreamEvent borrowedEvent = this.borrowEvent();
                this.streamEventConverter.convertComplexEvent((ComplexEvent)aEvent, borrowedEvent);
                boolean currentEventMatchedPrevPartitionExecutor = false;
                for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
                    String key = partitionExecutor.execute(borrowedEvent);
                    if (key == null) continue;
                    if (currentKey == null) {
                        currentKey = key;
                    } else if (!currentKey.equals(key)) {
                        Object firstEvent;
                        if (!currentEventMatchedPrevPartitionExecutor) {
                            firstEvent = outputEventChunk.getFirst();
                            this.send(currentKey, (ComplexEvent)firstEvent);
                            currentKey = key;
                            outputEventChunk.clear();
                        } else {
                            firstEvent = outputEventChunk.getFirst();
                            this.send(currentKey, (ComplexEvent)firstEvent);
                            currentKey = key;
                            outputEventChunk.clear();
                            StreamEvent cloneEvent = this.borrowEvent();
                            this.streamEventConverter.convertComplexEvent((ComplexEvent)aEvent, cloneEvent);
                            outputEventChunk.add(cloneEvent);
                        }
                    }
                    if (!currentEventMatchedPrevPartitionExecutor) {
                        outputEventChunk.add(borrowedEvent);
                    }
                    currentEventMatchedPrevPartitionExecutor = true;
                }
            }
            this.send(currentKey, (ComplexEvent)outputEventChunk.getFirst());
            outputEventChunk.clear();
        }
    }

    @Override
    public void receive(Event event) {
        StreamEvent borrowedEvent = this.borrowEvent();
        this.streamEventConverter.convertEvent(event, borrowedEvent);
        for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
            String key = partitionExecutor.execute(borrowedEvent);
            this.send(key, borrowedEvent);
        }
        if (this.partitionExecutors.size() == 0) {
            this.send(borrowedEvent);
        }
        this.returnEvents(borrowedEvent);
    }

    @Override
    public void receive(long timestamp, Object[] data) {
        StreamEvent borrowedEvent = this.borrowEvent();
        this.streamEventConverter.convertData(timestamp, data, borrowedEvent);
        if (this.partitionExecutors.size() == 0) {
            this.send(borrowedEvent);
        } else {
            for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
                String key = partitionExecutor.execute(borrowedEvent);
                this.send(key, borrowedEvent);
            }
        }
        this.returnEvents(borrowedEvent);
    }

    @Override
    public void receive(Event[] events) {
        if (this.partitionExecutors.size() == 0) {
            StreamEvent firstEvent = this.borrowEvent();
            this.streamEventConverter.convertEvent(events[0], firstEvent);
            StreamEvent currentEvent = firstEvent;
            for (int i = 1; i < events.length; ++i) {
                StreamEvent nextEvent = this.borrowEvent();
                this.streamEventConverter.convertEvent(events[i], nextEvent);
                currentEvent.setNext(nextEvent);
                currentEvent = nextEvent;
            }
            this.send(firstEvent);
            this.returnEvents(firstEvent);
        } else {
            String key = null;
            StreamEvent firstEvent = null;
            StreamEvent currentEvent = null;
            for (Event event : events) {
                StreamEvent nextEvent = this.borrowEvent();
                this.streamEventConverter.convertEvent(event, nextEvent);
                for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
                    String currentKey = partitionExecutor.execute(nextEvent);
                    if (currentKey == null) continue;
                    if (key == null) {
                        key = currentKey;
                        firstEvent = nextEvent;
                    } else if (!currentKey.equals(key)) {
                        this.send(key, firstEvent);
                        this.returnEvents(firstEvent);
                        key = currentKey;
                        firstEvent = nextEvent;
                    } else {
                        currentEvent.setNext(nextEvent);
                    }
                    currentEvent = nextEvent;
                }
            }
            this.send(key, firstEvent);
            this.returnEvents(firstEvent);
        }
    }

    @Override
    public void receive(List<Event> events) {
        if (this.partitionExecutors.size() == 0) {
            StreamEvent firstEvent = null;
            StreamEvent currentEvent = null;
            for (Event event : events) {
                StreamEvent nextEvent = this.borrowEvent();
                this.streamEventConverter.convertEvent(event, nextEvent);
                if (firstEvent == null) {
                    firstEvent = nextEvent;
                } else {
                    currentEvent.setNext(nextEvent);
                }
                currentEvent = nextEvent;
            }
            this.send(firstEvent);
            this.returnEvents(firstEvent);
        } else {
            String key = null;
            StreamEvent firstEvent = null;
            StreamEvent currentEvent = null;
            for (Event event : events) {
                StreamEvent nextEvent = this.borrowEvent();
                this.streamEventConverter.convertEvent(event, nextEvent);
                for (PartitionExecutor partitionExecutor : this.partitionExecutors) {
                    String currentKey = partitionExecutor.execute(nextEvent);
                    if (currentKey == null) continue;
                    if (key == null) {
                        key = currentKey;
                        firstEvent = nextEvent;
                    } else if (!currentKey.equals(key)) {
                        this.send(key, firstEvent);
                        this.returnEvents(firstEvent);
                        key = currentKey;
                        firstEvent = nextEvent;
                    } else {
                        currentEvent.setNext(nextEvent);
                    }
                    currentEvent = nextEvent;
                }
            }
            this.send(key, firstEvent);
            this.returnEvents(firstEvent);
        }
    }

    private void send(String key, ComplexEvent event) {
        if (key != null) {
            this.partitionRuntime.cloneIfNotExist(key);
            this.cachedStreamJunctionMap.get(this.streamId + key).sendEvent(event);
        }
    }

    private void send(ComplexEvent event) {
        for (StreamJunction streamJunction : this.cachedStreamJunctionMap.values()) {
            streamJunction.sendEvent(event);
        }
    }

    public void addStreamJunction(String key, List<QueryRuntime> queryRuntimeList) {
        StreamJunction streamJunction = this.cachedStreamJunctionMap.get(this.streamId + key);
        if (streamJunction == null) {
            streamJunction = (StreamJunction)this.partitionRuntime.getLocalStreamJunctionMap().get(this.streamId + key);
            if (streamJunction == null) {
                streamJunction = this.createStreamJunction();
                this.partitionRuntime.addStreamJunction(this.streamId + key, streamJunction);
            }
            this.cachedStreamJunctionMap.put(this.streamId + key, streamJunction);
        }
        for (QueryRuntime queryRuntime : queryRuntimeList) {
            StreamRuntime streamRuntime = queryRuntime.getStreamRuntime();
            for (int i = 0; i < queryRuntime.getInputStreamId().size(); ++i) {
                if (!streamRuntime.getSingleStreamRuntimes().get(i).getProcessStreamReceiver().getStreamId().equals(this.streamId + key)) continue;
                streamJunction.subscribe(streamRuntime.getSingleStreamRuntimes().get(i).getProcessStreamReceiver());
            }
        }
    }

    private StreamJunction createStreamJunction() {
        return new StreamJunction(this.streamDefinition, this.siddhiAppContext.getExecutorService(), this.siddhiAppContext.getBufferSize(), null, this.siddhiAppContext);
    }

    private synchronized StreamEvent borrowEvent() {
        return this.eventPool.borrowEvent();
    }

    private synchronized void returnEvents(StreamEvent events) {
        this.eventPool.returnEvents(events);
    }
}

