/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.math.multiply;

import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;

public class MultiplyExpressionExecutorLong
implements ExpressionExecutor {
    private ExpressionExecutor leftExpressionExecutor;
    private ExpressionExecutor rightExpressionExecutor;

    public MultiplyExpressionExecutorLong(ExpressionExecutor leftExpressionExecutor, ExpressionExecutor rightExpressionExecutor) {
        this.leftExpressionExecutor = leftExpressionExecutor;
        this.rightExpressionExecutor = rightExpressionExecutor;
    }

    @Override
    public Object execute(ComplexEvent event) {
        Object leftObject = this.leftExpressionExecutor.execute(event);
        Object rightObject = this.rightExpressionExecutor.execute(event);
        if (leftObject == null || rightObject == null) {
            return null;
        }
        return ((Number)leftObject).longValue() * ((Number)rightObject).longValue();
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.LONG;
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        return new MultiplyExpressionExecutorLong(this.leftExpressionExecutor.cloneExecutor(key), this.rightExpressionExecutor.cloneExecutor(key));
    }

    @Override
    public void clean() {
        this.leftExpressionExecutor.clean();
        this.rightExpressionExecutor.clean();
    }
}

