/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.math.mod;

import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;

public class ModExpressionExecutorLong
implements ExpressionExecutor {
    private ExpressionExecutor leftExpressionExecutor;
    private ExpressionExecutor rightExpressionExecutor;

    public ModExpressionExecutorLong(ExpressionExecutor leftExpressionExecutor, ExpressionExecutor rightExpressionExecutor) {
        this.leftExpressionExecutor = leftExpressionExecutor;
        this.rightExpressionExecutor = rightExpressionExecutor;
    }

    @Override
    public Object execute(ComplexEvent event) {
        Object leftObject = this.leftExpressionExecutor.execute(event);
        Object rightObject = this.rightExpressionExecutor.execute(event);
        if (leftObject == null || rightObject == null) {
            return null;
        }
        long right = ((Number)rightObject).longValue();
        if (right == 0L) {
            return null;
        }
        return ((Number)leftObject).longValue() % right;
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.LONG;
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        return new ModExpressionExecutorLong(this.leftExpressionExecutor.cloneExecutor(key), this.rightExpressionExecutor.cloneExecutor(key));
    }

    @Override
    public void clean() {
        this.leftExpressionExecutor.clean();
        this.rightExpressionExecutor.clean();
    }
}

