/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.expression.Expression;

@Extension(name="sort", namespace="", description="This window holds a batch of events that equal the number specified as the windowLength and sorts them in the given order.", parameters={@Parameter(name="window.length", description="The size of the window length.", type={DataType.INT}), @Parameter(name="attribute", description="The attribute that should be checked for the order.", type={DataType.STRING}, optional=true, defaultValue="The concatenation of all the attributes of the event is considered."), @Parameter(name="order", description="The order define as \"asc\" or \"desc\".", type={DataType.STRING}, optional=true, defaultValue="asc")}, examples={@Example(syntax="define stream cseEventStream (symbol string, price float, volume long);\ndefine window cseEventWindow (symbol string, price float, volume long) sort(2,volume, 'asc');\n@info(name = 'query0')\nfrom cseEventStream\ninsert into cseEventWindow;\n@info(name = 'query1')\nfrom cseEventWindow\nselect volume\ninsert all events into outputStream ;", description="sort(5, price, 'asc') keeps the events sorted by price in the ascending order. Therefore, at any given time, the window contains the 5 lowest prices.")})
public class SortWindowProcessor
extends WindowProcessor
implements FindableProcessor {
    private static final String ASC = "asc";
    private static final String DESC = "desc";
    private int lengthToKeep;
    private List<StreamEvent> sortedWindow = new ArrayList<StreamEvent>();
    private List<Object[]> parameterInfo;
    private EventComparator eventComparator;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.INT) {
            throw new UnsupportedOperationException("The first parameter should be an integer");
        }
        this.lengthToKeep = Integer.parseInt(String.valueOf(((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue()));
        this.parameterInfo = new ArrayList<Object[]>();
        this.eventComparator = new EventComparator();
        int parametersLength = attributeExpressionExecutors.length;
        for (int i = 1; i < parametersLength; ++i) {
            int order;
            if (!(attributeExpressionExecutors[i] instanceof VariableExpressionExecutor)) {
                throw new UnsupportedOperationException("Required a variable, but found a string parameter");
            }
            ExpressionExecutor variableExpressionExecutor = attributeExpressionExecutors[i];
            if (i + 1 < parametersLength && attributeExpressionExecutors[i + 1].getReturnType() == Attribute.Type.STRING) {
                String nextParameter = (String)((ConstantExpressionExecutor)attributeExpressionExecutors[i + 1]).getValue();
                if (nextParameter.equalsIgnoreCase(DESC)) {
                    order = -1;
                    ++i;
                } else {
                    if (!nextParameter.equalsIgnoreCase(ASC)) throw new UnsupportedOperationException("Parameter string literals should only be \"asc\" or \"desc\"");
                    order = 1;
                    ++i;
                }
            } else {
                order = 1;
            }
            this.parameterInfo.add(new Object[]{variableExpressionExecutor, order});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        SortWindowProcessor sortWindowProcessor = this;
        synchronized (sortWindowProcessor) {
            long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
            StreamEvent streamEvent = streamEventChunk.getFirst();
            streamEventChunk.clear();
            while (streamEvent != null) {
                StreamEvent clonedEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedEvent.setType(ComplexEvent.Type.EXPIRED);
                StreamEvent next = streamEvent.getNext();
                streamEvent.setNext(null);
                streamEventChunk.add(streamEvent);
                this.sortedWindow.add(clonedEvent);
                if (this.sortedWindow.size() > this.lengthToKeep) {
                    Collections.sort(this.sortedWindow, this.eventComparator);
                    StreamEvent expiredEvent = this.sortedWindow.remove(this.sortedWindow.size() - 1);
                    expiredEvent.setTimestamp(currentTime);
                    streamEventChunk.add(expiredEvent);
                }
                streamEvent = next;
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        SortWindowProcessor sortWindowProcessor = this;
        synchronized (sortWindowProcessor) {
            state.put("SortedWindow", this.sortedWindow);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.sortedWindow = (List)state.get("SortedWindow");
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        return ((Operator)compiledCondition).find(matchingEvent, this.sortedWindow, this.streamEventCloner);
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        return OperatorParser.constructOperator(this.sortedWindow, condition, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, this.queryName);
    }

    private class EventComparator
    implements Comparator<StreamEvent> {
        private EventComparator() {
        }

        @Override
        public int compare(StreamEvent e1, StreamEvent e2) {
            for (Object[] listItem : SortWindowProcessor.this.parameterInfo) {
                Comparable comparableVariable2;
                int[] variablePosition = ((VariableExpressionExecutor)listItem[0]).getPosition();
                Comparable comparableVariable1 = (Comparable)e1.getAttribute(variablePosition);
                int comparisonResult = comparableVariable1.compareTo(comparableVariable2 = (Comparable)e2.getAttribute(variablePosition));
                if (comparisonResult == 0) continue;
                return (Integer)listItem[1] * comparisonResult;
            }
            return 0;
        }
    }
}

