/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;

public abstract class FunctionExecutor
implements ExpressionExecutor,
Snapshotable {
    private static final Logger log = Logger.getLogger(FunctionExecutor.class);
    protected ExpressionExecutor[] attributeExpressionExecutors;
    protected SiddhiAppContext siddhiAppContext;
    protected String elementId;
    protected String functionId;
    protected String queryName;
    private ConfigReader configReader;
    private int attributeSize;

    public void initExecutor(ExpressionExecutor[] attributeExpressionExecutors, SiddhiAppContext siddhiAppContext, String queryName, ConfigReader configReader) {
        this.configReader = configReader;
        try {
            this.siddhiAppContext = siddhiAppContext;
            this.attributeExpressionExecutors = attributeExpressionExecutors;
            this.attributeSize = attributeExpressionExecutors.length;
            this.queryName = queryName;
            if (this.elementId == null) {
                this.elementId = "FunctionExecutor-" + siddhiAppContext.getElementIdGenerator().createNewId();
            }
            siddhiAppContext.getSnapshotService().addSnapshotable(queryName, this);
            this.init(attributeExpressionExecutors, configReader, siddhiAppContext);
        }
        catch (Throwable t) {
            throw new SiddhiAppCreationException(t);
        }
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        try {
            FunctionExecutor functionExecutor = (FunctionExecutor)this.getClass().newInstance();
            ExpressionExecutor[] innerExpressionExecutors = new ExpressionExecutor[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                innerExpressionExecutors[i] = this.attributeExpressionExecutors[i].cloneExecutor(key);
            }
            functionExecutor.elementId = this.elementId + "-" + key;
            functionExecutor.functionId = this.functionId;
            functionExecutor.initExecutor(innerExpressionExecutors, this.siddhiAppContext, this.queryName, this.configReader);
            return functionExecutor;
        }
        catch (Exception e) {
            throw new SiddhiAppRuntimeException("Exception in cloning " + this.getClass().getCanonicalName(), e);
        }
    }

    protected abstract void init(ExpressionExecutor[] var1, ConfigReader var2, SiddhiAppContext var3);

    @Override
    public Object execute(ComplexEvent event) {
        try {
            switch (this.attributeSize) {
                case 0: {
                    return this.execute((Object)null);
                }
                case 1: {
                    return this.execute(this.attributeExpressionExecutors[0].execute(event));
                }
            }
            Object[] data = new Object[this.attributeSize];
            for (int i = 0; i < this.attributeSize; ++i) {
                data[i] = this.attributeExpressionExecutors[i].execute(event);
            }
            return this.execute(data);
        }
        catch (Exception e) {
            throw new SiddhiAppRuntimeException(e.getMessage() + ". Exception on class '" + this.getClass().getName() + "'", e);
        }
    }

    protected abstract Object execute(Object[] var1);

    protected abstract Object execute(Object var1);

    @Override
    public String getElementId() {
        return this.elementId;
    }
}

