/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="or", namespace="", description="Returns the results of OR operation for all the events.", parameters={@Parameter(name="arg", description="The value that needs to be OR operation.", type={DataType.BOOL})}, returnAttributes={@ReturnAttribute(description="Returns false only if all of its operands are false, else true.", type={DataType.BOOL})}, examples={@Example(syntax="from cscStream#window.lengthBatch(10)\nselect or(isFraud) as isFraudTransaction\ninsert into alertStream;", description="This will returns the result for OR operation of isFraud values as a boolean value for event chunk expiry by window length batch.")})
public class OrAttributeAggregator
extends AttributeAggregator {
    private static Attribute.Type type = Attribute.Type.BOOL;
    private int trueEventsCount = 0;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("And aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return type;
    }

    @Override
    public Object processAdd(Object data) {
        if (((Boolean)data).booleanValue()) {
            ++this.trueEventsCount;
        }
        return this.computeLogicalOperation();
    }

    @Override
    public Object processAdd(Object[] data) {
        for (Object object : data) {
            if (!((Boolean)object).booleanValue()) continue;
            ++this.trueEventsCount;
        }
        return this.computeLogicalOperation();
    }

    @Override
    public Object processRemove(Object data) {
        if (((Boolean)data).booleanValue()) {
            --this.trueEventsCount;
        }
        return this.computeLogicalOperation();
    }

    @Override
    public Object processRemove(Object[] data) {
        for (Object object : data) {
            if (!((Boolean)object).booleanValue()) continue;
            --this.trueEventsCount;
        }
        return this.computeLogicalOperation();
    }

    private boolean computeLogicalOperation() {
        return this.trueEventsCount > 0;
    }

    @Override
    public Object reset() {
        this.trueEventsCount = 0;
        return false;
    }

    @Override
    public boolean canDestroy() {
        return this.trueEventsCount == 0;
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("trueEventsCount", this.trueEventsCount);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.trueEventsCount = (Integer)state.get("trueEventsCount");
    }
}

