/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.core.util.snapshot.state.SnapshotStateList;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

@Extension(name="lengthBatch", namespace="", description="A batch (tumbling) length window that holds a number of events specified as the windowLength. The window is updated each time a batch of events that equals the number specified as the windowLength arrives.", parameters={@Parameter(name="window.length", description="The number of events the window should tumble.", type={DataType.INT})}, examples={@Example(syntax="define window cseEventWindow (symbol string, price float, volume int) lengthBatch(10) output all events;\n\n@info(name = 'query0')\nfrom cseEventStream\ninsert into cseEventWindow;\n\n@info(name = 'query1')\nfrom cseEventWindow\nselect symbol, sum(price) as price\ninsert all events into outputStream ;", description="This will processing 10 events as a batch and out put all events.")})
public class LengthBatchWindowProcessor
extends WindowProcessor
implements FindableProcessor {
    private int length;
    private int count = 0;
    private SnapshotableStreamEventQueue currentEventQueue;
    private SnapshotableStreamEventQueue expiredEventQueue = null;
    private boolean outputExpectsExpiredEvents;
    private SiddhiAppContext siddhiAppContext;
    private StreamEvent resetEvent = null;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiAppContext siddhiAppContext) {
        this.outputExpectsExpiredEvents = outputExpectsExpiredEvents;
        this.siddhiAppContext = siddhiAppContext;
        this.currentEventQueue = new SnapshotableStreamEventQueue(this.streamEventClonerHolder);
        if (outputExpectsExpiredEvents) {
            this.expiredEventQueue = new SnapshotableStreamEventQueue(this.streamEventClonerHolder);
        }
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Length batch window should only have one parameter (<int> windowLength), but found " + attributeExpressionExecutors.length + " input attributes");
        }
        this.length = (Integer)((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        ArrayList<ComplexEventChunk<StreamEvent>> streamEventChunks = new ArrayList<ComplexEventChunk<StreamEvent>>();
        LengthBatchWindowProcessor lengthBatchWindowProcessor = this;
        synchronized (lengthBatchWindowProcessor) {
            ComplexEventChunk<StreamEvent> outputStreamEventChunk = new ComplexEventChunk<StreamEvent>(true);
            long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(streamEvent);
                this.currentEventQueue.add(clonedStreamEvent);
                ++this.count;
                if (this.count != this.length) continue;
                if (this.outputExpectsExpiredEvents && this.expiredEventQueue.getFirst() != null) {
                    while (this.expiredEventQueue.hasNext()) {
                        StreamEvent expiredEvent = this.expiredEventQueue.next();
                        expiredEvent.setTimestamp(currentTime);
                    }
                    outputStreamEventChunk.add(this.expiredEventQueue.getFirst());
                }
                if (this.expiredEventQueue != null) {
                    this.expiredEventQueue.clear();
                }
                if (this.currentEventQueue.getFirst() != null) {
                    outputStreamEventChunk.add(this.resetEvent);
                    this.resetEvent = null;
                    if (this.expiredEventQueue != null) {
                        this.currentEventQueue.reset();
                        while (this.currentEventQueue.hasNext()) {
                            StreamEvent currentEvent = this.currentEventQueue.next();
                            StreamEvent toExpireEvent = streamEventCloner.copyStreamEvent(currentEvent);
                            toExpireEvent.setType(ComplexEvent.Type.EXPIRED);
                            this.expiredEventQueue.add(toExpireEvent);
                        }
                    }
                    this.resetEvent = streamEventCloner.copyStreamEvent(this.currentEventQueue.getFirst());
                    this.resetEvent.setType(ComplexEvent.Type.RESET);
                    outputStreamEventChunk.add(this.currentEventQueue.getFirst());
                }
                this.currentEventQueue.clear();
                this.count = 0;
                if (outputStreamEventChunk.getFirst() == null) continue;
                streamEventChunks.add(outputStreamEventChunk);
                outputStreamEventChunk = new ComplexEventChunk<StreamEvent>(true);
            }
        }
        for (ComplexEventChunk<StreamEvent> outputStreamEventChunk : streamEventChunks) {
            nextProcessor.process(outputStreamEventChunk);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        LengthBatchWindowProcessor lengthBatchWindowProcessor = this;
        synchronized (lengthBatchWindowProcessor) {
            state.put("Count", this.count);
            state.put("CurrentEventQueue", this.currentEventQueue.getSnapshot());
            state.put("ExpiredEventQueue", this.expiredEventQueue.getSnapshot());
            state.put("ResetEvent", this.resetEvent);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.count = (Integer)state.get("Count");
        this.currentEventQueue.clear();
        this.currentEventQueue.restore((SnapshotStateList)state.get("CurrentEventQueue"));
        if (this.expiredEventQueue != null) {
            this.expiredEventQueue.clear();
            this.expiredEventQueue.restore((SnapshotStateList)state.get("ExpiredEventQueue"));
        }
        this.resetEvent = (StreamEvent)state.get("ResetEvent");
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        return ((Operator)compiledCondition).find(matchingEvent, this.expiredEventQueue, this.streamEventCloner);
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        if (this.expiredEventQueue == null) {
            this.expiredEventQueue = new SnapshotableStreamEventQueue(this.streamEventClonerHolder);
        }
        return OperatorParser.constructOperator(this.expiredEventQueue, condition, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, this.queryName);
    }
}

