/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.snapshot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.parser.SchedulerParser;

public class PerSnapshotOutputRateLimiter
extends SnapshotOutputRateLimiter {
    private final Long value;
    private String id;
    private ScheduledExecutorService scheduledExecutorService;
    private ComplexEventChunk<ComplexEvent> eventChunk = new ComplexEventChunk(false);
    private ComplexEvent lastEvent;
    private Scheduler scheduler;
    private long scheduledTime;
    private String queryName;

    public PerSnapshotOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, SiddhiAppContext siddhiAppContext, String queryName) {
        super(wrappedSnapshotOutputRateLimiter, siddhiAppContext);
        this.queryName = queryName;
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList<ComplexEventChunk<ComplexEvent>> outputEventChunks = new ArrayList<ComplexEventChunk<ComplexEvent>>();
        complexEventChunk.reset();
        PerSnapshotOutputRateLimiter perSnapshotOutputRateLimiter = this;
        synchronized (perSnapshotOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() == ComplexEvent.Type.TIMER) {
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)object);
                    continue;
                }
                if (object.getType() == ComplexEvent.Type.CURRENT) {
                    complexEventChunk.remove();
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)object);
                    this.lastEvent = object;
                    continue;
                }
                this.tryFlushEvents(outputEventChunks, (ComplexEvent)object);
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    private void tryFlushEvents(List<ComplexEventChunk<ComplexEvent>> outputEventChunks, ComplexEvent event) {
        if (event.getTimestamp() >= this.scheduledTime) {
            ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(false);
            if (this.lastEvent != null) {
                outputEventChunk.add(this.cloneComplexEvent(this.lastEvent));
            }
            outputEventChunks.add(outputEventChunk);
            this.scheduledTime += this.value.longValue();
            this.scheduler.notifyAt(this.scheduledTime);
        }
    }

    @Override
    public SnapshotOutputRateLimiter clone(String key, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter) {
        return new PerSnapshotOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, wrappedSnapshotOutputRateLimiter, this.siddhiAppContext, this.queryName);
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this, this.siddhiAppContext);
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.queryName);
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        PerSnapshotOutputRateLimiter perSnapshotOutputRateLimiter = this;
        synchronized (perSnapshotOutputRateLimiter) {
            state.put("EventChunk", this.eventChunk.getFirst());
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.eventChunk.clear();
        this.eventChunk.add((ComplexEvent)state.get("EventList"));
    }
}

