/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.config;

import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.core.util.config.ConfigManager;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.config.InMemoryConfigReader;

public class InMemoryConfigManager
implements ConfigManager {
    private Map<String, String> extensionMasterConfigs = new HashMap<String, String>();
    private Map<String, String> systemConfigs = new HashMap<String, String>();
    private Map<String, String> properties = new HashMap<String, String>();

    public InMemoryConfigManager(Map<String, String> extensionMasterConfigs, Map<String, String> systemConfigs) {
        if (extensionMasterConfigs != null) {
            this.extensionMasterConfigs = extensionMasterConfigs;
        }
        if (systemConfigs != null) {
            this.systemConfigs = systemConfigs;
        }
    }

    public InMemoryConfigManager(Map<String, String> extensionMasterConfigs, Map<String, String> systemConfigs, Map<String, String> properties) {
        if (extensionMasterConfigs != null) {
            this.extensionMasterConfigs = extensionMasterConfigs;
        }
        if (systemConfigs != null) {
            this.systemConfigs = systemConfigs;
        }
        if (properties != null) {
            this.properties = properties;
        }
    }

    public InMemoryConfigManager() {
    }

    @Override
    public ConfigReader generateConfigReader(String namespace, String name) {
        String keyPrefix = namespace + "." + name;
        HashMap<String, String> configs = new HashMap<String, String>();
        for (Map.Entry<String, String> config : this.extensionMasterConfigs.entrySet()) {
            if (!config.getKey().startsWith(keyPrefix)) continue;
            configs.put(config.getKey(), config.getValue());
        }
        return new InMemoryConfigReader(keyPrefix, configs);
    }

    @Override
    public Map<String, String> extractSystemConfigs(String name) {
        HashMap<String, String> configs = new HashMap<String, String>();
        for (Map.Entry<String, String> store : this.systemConfigs.entrySet()) {
            if (!store.getKey().startsWith(name)) continue;
            configs.put(store.getKey().replaceFirst(name + ".", ""), store.getValue());
        }
        return configs;
    }

    @Override
    public String extractProperty(String name) {
        if (this.properties != null) {
            return this.properties.get(name);
        }
        return null;
    }
}

