/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.aggregation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.core.aggregation.BaseIncrementalValueStore;
import org.wso2.siddhi.core.aggregation.IncrementalExecutor;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.util.IncrementalTimeConverterUtil;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;

public class IncrementalDataAggregator {
    private final List<TimePeriod.Duration> incrementalDurations;
    private final TimePeriod.Duration aggregateForDuration;
    private final BaseIncrementalValueStore baseIncrementalValueStore;
    private final Map<String, BaseIncrementalValueStore> baseIncrementalValueStoreGroupByMap;

    public IncrementalDataAggregator(List<TimePeriod.Duration> incrementalDurations, TimePeriod.Duration aggregateForDuration, long oldestEventTimeStamp, List<ExpressionExecutor> baseExecutors, MetaStreamEvent metaStreamEvent, SiddhiAppContext siddhiAppContext, ExpressionExecutor shouldUpdateExpressionExecutor) {
        this.incrementalDurations = incrementalDurations;
        this.aggregateForDuration = aggregateForDuration;
        StreamEventPool streamEventPool = new StreamEventPool(metaStreamEvent, 10);
        this.baseIncrementalValueStore = new BaseIncrementalValueStore(oldestEventTimeStamp, baseExecutors, streamEventPool, siddhiAppContext, null, shouldUpdateExpressionExecutor);
        this.baseIncrementalValueStoreGroupByMap = new HashMap<String, BaseIncrementalValueStore>();
    }

    public ComplexEventChunk<StreamEvent> aggregateInMemoryData(Map<TimePeriod.Duration, IncrementalExecutor> incrementalExecutorMap) {
        int startIndex;
        for (int i = startIndex = this.incrementalDurations.indexOf(this.aggregateForDuration); i >= 0; --i) {
            TimePeriod.Duration duration = this.incrementalDurations.get(i);
            IncrementalExecutor incrementalExecutor = incrementalExecutorMap.get(duration);
            Map<String, BaseIncrementalValueStore> baseIncrementalValueStoreGroupByMap = incrementalExecutor.getBaseIncrementalValueStoreGroupByMap();
            BaseIncrementalValueStore baseIncrementalValueStore = incrementalExecutor.getBaseIncrementalValueStore();
            if (baseIncrementalValueStoreGroupByMap != null) {
                for (Map.Entry<String, BaseIncrementalValueStore> entry : baseIncrementalValueStoreGroupByMap.entrySet()) {
                    BaseIncrementalValueStore aBaseIncrementalValueStore = entry.getValue();
                    if (!aBaseIncrementalValueStore.isProcessed()) continue;
                    this.processInMemoryAggregates(aBaseIncrementalValueStore.createStreamEvent(), aBaseIncrementalValueStore.getTimestamp(), entry.getKey());
                }
                continue;
            }
            if (!baseIncrementalValueStore.isProcessed()) continue;
            this.processInMemoryAggregates(baseIncrementalValueStore.createStreamEvent(), baseIncrementalValueStore.getTimestamp(), null);
        }
        return this.createEventChunkFromAggregatedData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInMemoryAggregates(StreamEvent streamEvent, long timestamp, String groupByKey) {
        long startTimeOfAggregates = IncrementalTimeConverterUtil.getStartTimeOfAggregates(timestamp, this.aggregateForDuration);
        IncrementalDataAggregator incrementalDataAggregator = this;
        synchronized (incrementalDataAggregator) {
            if (groupByKey != null) {
                BaseIncrementalValueStore aBaseIncrementalValueStore = this.baseIncrementalValueStoreGroupByMap.computeIfAbsent(groupByKey, k -> this.baseIncrementalValueStore.cloneStore((String)k, startTimeOfAggregates));
                this.process(streamEvent, aBaseIncrementalValueStore);
            } else {
                this.process(streamEvent, this.baseIncrementalValueStore);
            }
        }
    }

    private void process(StreamEvent streamEvent, BaseIncrementalValueStore baseIncrementalValueStore) {
        List<ExpressionExecutor> expressionExecutors = baseIncrementalValueStore.getExpressionExecutors();
        boolean shouldUpdate = true;
        ExpressionExecutor shouldUpdateExpressionExecutor = baseIncrementalValueStore.getShouldUpdateExpressionExecutor();
        if (shouldUpdateExpressionExecutor != null) {
            shouldUpdate = (Boolean)shouldUpdateExpressionExecutor.execute(streamEvent);
        }
        for (int i = 0; i < expressionExecutors.size(); ++i) {
            ExpressionExecutor expressionExecutor;
            if (shouldUpdate) {
                expressionExecutor = expressionExecutors.get(i);
                baseIncrementalValueStore.setValue(expressionExecutor.execute(streamEvent), i + 1);
                continue;
            }
            expressionExecutor = expressionExecutors.get(i);
            if (expressionExecutor instanceof VariableExpressionExecutor) continue;
            baseIncrementalValueStore.setValue(expressionExecutor.execute(streamEvent), i + 1);
        }
        baseIncrementalValueStore.setProcessed(true);
    }

    private ComplexEventChunk<StreamEvent> createEventChunkFromAggregatedData() {
        ComplexEventChunk<StreamEvent> processedInMemoryEventChunk = new ComplexEventChunk<StreamEvent>(true);
        if (this.baseIncrementalValueStoreGroupByMap.size() == 0) {
            if (this.baseIncrementalValueStore.isProcessed()) {
                processedInMemoryEventChunk.add(this.baseIncrementalValueStore.createStreamEvent());
            }
        } else {
            for (Map.Entry<String, BaseIncrementalValueStore> entryAgainstGroupBy : this.baseIncrementalValueStoreGroupByMap.entrySet()) {
                processedInMemoryEventChunk.add(entryAgainstGroupBy.getValue().createStreamEvent());
            }
        }
        return processedInMemoryEventChunk;
    }
}

