/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverter;
import org.wso2.siddhi.core.event.stream.converter.StreamEventConverterFactory;
import org.wso2.siddhi.core.query.input.ProcessStreamReceiver;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;

public class MultiProcessStreamReceiver
extends ProcessStreamReceiver {
    protected Processor[] nextProcessors;
    protected int processCount;
    protected int[] eventSequence;
    protected String queryName;
    protected OutputRateLimiter outputRateLimiter;
    private MetaStreamEvent[] metaStreamEvents;
    private StreamEventPool[] streamEventPools;
    private StreamEventConverter[] streamEventConverters;
    private static ThreadLocal<ReturnEventHolder> multiProcessReturn = new ThreadLocal();

    public MultiProcessStreamReceiver(String streamId, int processCount, LatencyTracker latencyTracker, String queryName, SiddhiAppContext siddhiAppContext) {
        super(streamId, latencyTracker, queryName, siddhiAppContext);
        this.processCount = processCount;
        this.queryName = queryName;
        this.nextProcessors = new Processor[processCount];
        this.metaStreamEvents = new MetaStreamEvent[processCount];
        this.streamEventPools = new StreamEventPool[processCount];
        this.streamEventConverters = new StreamEventConverter[processCount];
        this.eventSequence = new int[processCount];
        for (int i = 0; i < this.eventSequence.length; ++i) {
            this.eventSequence[i] = i;
        }
    }

    @Override
    public MultiProcessStreamReceiver clone(String key) {
        return new MultiProcessStreamReceiver(this.streamId + key, this.processCount, this.latencyTracker, this.queryName, this.siddhiAppContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(int eventSequence, StreamEvent borrowedEvent) {
        block9: {
            if (this.lockWrapper != null) {
                this.lockWrapper.lock();
            }
            try {
                if (this.latencyTracker != null) {
                    try {
                        this.latencyTracker.markIn();
                        this.processAndClear(eventSequence, borrowedEvent);
                        break block9;
                    }
                    finally {
                        this.latencyTracker.markOut();
                    }
                }
                this.processAndClear(eventSequence, borrowedEvent);
            }
            finally {
                if (this.lockWrapper != null) {
                    this.lockWrapper.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void receive(ComplexEvent complexEvent) {
        ComplexEvent aComplexEvent = complexEvent;
        while (aComplexEvent != null) {
            if (this.outputRateLimiter == null) {
                MultiProcessStreamReceiver multiProcessStreamReceiver = this;
                // MONITORENTER : multiProcessStreamReceiver
                this.stabilizeStates();
                for (int anEventSequence : this.eventSequence) {
                    StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                    StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                    aStreamEventConverter.convertComplexEvent(aComplexEvent, borrowedEvent);
                    this.process(anEventSequence, borrowedEvent);
                }
                // MONITOREXIT : multiProcessStreamReceiver
            } else {
                Object object;
                ArrayList<ReturnEventHolder> returnEventHolderList = new ArrayList<ReturnEventHolder>(this.eventSequence.length);
                try {
                    multiProcessReturn.set(new ReturnEventHolder());
                    MultiProcessStreamReceiver multiProcessStreamReceiver = this;
                    object = multiProcessStreamReceiver;
                    // MONITORENTER : multiProcessStreamReceiver
                    this.stabilizeStates();
                    for (int anEventSequence : this.eventSequence) {
                        StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                        StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                        StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                        aStreamEventConverter.convertComplexEvent(aComplexEvent, borrowedEvent);
                        this.process(anEventSequence, borrowedEvent);
                        if (multiProcessReturn.get() == null || MultiProcessStreamReceiver.multiProcessReturn.get().complexEventChunk == null) continue;
                        returnEventHolderList.add(multiProcessReturn.get());
                        multiProcessReturn.set(new ReturnEventHolder());
                    }
                    // MONITOREXIT : object
                }
                finally {
                    multiProcessReturn.set(null);
                }
                object = returnEventHolderList.iterator();
                while (object.hasNext()) {
                    ReturnEventHolder returnEventHolder = (ReturnEventHolder)object.next();
                    this.outputRateLimiter.sendToCallBacks(returnEventHolder.complexEventChunk);
                }
            }
            aComplexEvent = aComplexEvent.getNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(Event event) {
        if (this.outputRateLimiter == null) {
            MultiProcessStreamReceiver multiProcessStreamReceiver = this;
            synchronized (multiProcessStreamReceiver) {
                this.stabilizeStates();
                for (int anEventSequence : this.eventSequence) {
                    StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                    StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                    aStreamEventConverter.convertEvent(event, borrowedEvent);
                    this.process(anEventSequence, borrowedEvent);
                }
            }
        }
        ArrayList<ReturnEventHolder> returnEventHolderList = new ArrayList<ReturnEventHolder>(this.eventSequence.length);
        try {
            multiProcessReturn.set(new ReturnEventHolder());
            MultiProcessStreamReceiver multiProcessStreamReceiver = this;
            synchronized (multiProcessStreamReceiver) {
                this.stabilizeStates();
                for (int anEventSequence : this.eventSequence) {
                    StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                    StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                    aStreamEventConverter.convertEvent(event, borrowedEvent);
                    this.process(anEventSequence, borrowedEvent);
                    if (multiProcessReturn.get() == null || MultiProcessStreamReceiver.multiProcessReturn.get().complexEventChunk == null) continue;
                    returnEventHolderList.add(multiProcessReturn.get());
                    multiProcessReturn.set(new ReturnEventHolder());
                }
            }
        }
        finally {
            multiProcessReturn.set(null);
        }
        for (ReturnEventHolder returnEventHolder : returnEventHolderList) {
            this.outputRateLimiter.sendToCallBacks(returnEventHolder.complexEventChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void receive(Event[] events) {
        Event[] eventArray = events;
        int n = eventArray.length;
        int n2 = 0;
        while (n2 < n) {
            Event event = eventArray[n2];
            if (this.outputRateLimiter == null) {
                MultiProcessStreamReceiver multiProcessStreamReceiver = this;
                // MONITORENTER : multiProcessStreamReceiver
                this.stabilizeStates();
                for (int anEventSequence : this.eventSequence) {
                    StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                    StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                    aStreamEventConverter.convertEvent(event, borrowedEvent);
                    this.process(anEventSequence, borrowedEvent);
                }
                // MONITOREXIT : multiProcessStreamReceiver
            } else {
                Object object;
                ArrayList<ReturnEventHolder> returnEventHolderList = new ArrayList<ReturnEventHolder>(this.eventSequence.length);
                try {
                    multiProcessReturn.set(new ReturnEventHolder());
                    MultiProcessStreamReceiver multiProcessStreamReceiver = this;
                    object = multiProcessStreamReceiver;
                    // MONITORENTER : multiProcessStreamReceiver
                    this.stabilizeStates();
                    for (int anEventSequence : this.eventSequence) {
                        StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                        StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                        StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                        aStreamEventConverter.convertEvent(event, borrowedEvent);
                        this.process(anEventSequence, borrowedEvent);
                        if (multiProcessReturn.get() == null || MultiProcessStreamReceiver.multiProcessReturn.get().complexEventChunk == null) continue;
                        returnEventHolderList.add(multiProcessReturn.get());
                        multiProcessReturn.set(new ReturnEventHolder());
                    }
                    // MONITOREXIT : object
                }
                finally {
                    multiProcessReturn.set(null);
                }
                object = returnEventHolderList.iterator();
                while (object.hasNext()) {
                    ReturnEventHolder returnEventHolder = (ReturnEventHolder)object.next();
                    this.outputRateLimiter.sendToCallBacks(returnEventHolder.complexEventChunk);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void receive(List<Event> events) {
        var2_2 = events.iterator();
        block7: while (true) {
            if (var2_2.hasNext() == false) return;
            event = var2_2.next();
            if (this.outputRateLimiter == null) {
                var4_4 = this;
                // MONITORENTER : var4_4
                this.stabilizeStates();
                for (int anEventSequence : this.eventSequence) {
                    aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    aStreamEventPool = this.streamEventPools[anEventSequence];
                    borrowedEvent = aStreamEventPool.borrowEvent();
                    aStreamEventConverter.convertEvent(event, borrowedEvent);
                    this.process(anEventSequence, borrowedEvent);
                }
                // MONITOREXIT : var4_4
                continue;
            }
            returnEventHolderList = new ArrayList<ReturnEventHolder>(this.eventSequence.length);
            try {
                MultiProcessStreamReceiver.multiProcessReturn.set(new ReturnEventHolder());
                v0 = this;
                var5_5 = v0;
                // MONITORENTER : v0
                this.stabilizeStates();
                for (int anEventSequence : this.eventSequence) {
                    aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    aStreamEventPool = this.streamEventPools[anEventSequence];
                    borrowedEvent = aStreamEventPool.borrowEvent();
                    aStreamEventConverter.convertEvent(event, borrowedEvent);
                    this.process(anEventSequence, borrowedEvent);
                    if (MultiProcessStreamReceiver.multiProcessReturn.get() == null || MultiProcessStreamReceiver.multiProcessReturn.get().complexEventChunk == null) continue;
                    returnEventHolderList.add(MultiProcessStreamReceiver.multiProcessReturn.get());
                    MultiProcessStreamReceiver.multiProcessReturn.set(new ReturnEventHolder());
                }
                // MONITOREXIT : var5_5
            }
            finally {
                MultiProcessStreamReceiver.multiProcessReturn.set(null);
            }
            var5_5 = returnEventHolderList.iterator();
            while (true) {
                if (var5_5.hasNext()) ** break;
                continue block7;
                returnEventHolder = (ReturnEventHolder)var5_5.next();
                this.outputRateLimiter.sendToCallBacks(returnEventHolder.complexEventChunk);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(long timestamp, Object[] data) {
        if (this.outputRateLimiter == null) {
            MultiProcessStreamReceiver multiProcessStreamReceiver = this;
            synchronized (multiProcessStreamReceiver) {
                this.stabilizeStates();
                for (int anEventSequence : this.eventSequence) {
                    StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                    StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                    aStreamEventConverter.convertData(timestamp, data, borrowedEvent);
                    this.process(anEventSequence, borrowedEvent);
                }
            }
        }
        ArrayList<ReturnEventHolder> returnEventHolderList = new ArrayList<ReturnEventHolder>(this.eventSequence.length);
        try {
            multiProcessReturn.set(new ReturnEventHolder());
            MultiProcessStreamReceiver multiProcessStreamReceiver = this;
            synchronized (multiProcessStreamReceiver) {
                this.stabilizeStates();
                for (int anEventSequence : this.eventSequence) {
                    StreamEventConverter aStreamEventConverter = this.streamEventConverters[anEventSequence];
                    StreamEventPool aStreamEventPool = this.streamEventPools[anEventSequence];
                    StreamEvent borrowedEvent = aStreamEventPool.borrowEvent();
                    aStreamEventConverter.convertData(timestamp, data, borrowedEvent);
                    this.process(anEventSequence, borrowedEvent);
                    if (multiProcessReturn.get() == null || MultiProcessStreamReceiver.multiProcessReturn.get().complexEventChunk == null) continue;
                    returnEventHolderList.add(multiProcessReturn.get());
                    multiProcessReturn.set(new ReturnEventHolder());
                }
            }
        }
        finally {
            multiProcessReturn.set(null);
        }
        for (ReturnEventHolder returnEventHolder : returnEventHolderList) {
            this.outputRateLimiter.sendToCallBacks(returnEventHolder.complexEventChunk);
        }
    }

    protected void processAndClear(int processIndex, StreamEvent streamEvent) {
        ComplexEventChunk<StreamEvent> currentStreamEventChunk = new ComplexEventChunk<StreamEvent>(streamEvent, streamEvent, this.batchProcessingAllowed);
        this.nextProcessors[processIndex].process(currentStreamEventChunk);
    }

    protected void stabilizeStates() {
    }

    @Override
    public void setNext(Processor nextProcessor) {
        for (Processor processor : this.nextProcessors) {
            if (processor != null) continue;
            this.nextProcessors[i] = nextProcessor;
            break;
        }
    }

    @Override
    public void setMetaStreamEvent(MetaStreamEvent metaStreamEvent) {
        for (MetaStreamEvent streamEvent : this.metaStreamEvents) {
            if (streamEvent != null) continue;
            this.metaStreamEvents[i] = metaStreamEvent;
            break;
        }
    }

    @Override
    public boolean toStream() {
        return this.metaStreamEvents[0].getEventType() == MetaStreamEvent.EventType.DEFAULT || this.metaStreamEvents[0].getEventType() == MetaStreamEvent.EventType.WINDOW;
    }

    @Override
    public void setStreamEventPool(StreamEventPool streamEventPool) {
        for (StreamEventPool eventPool : this.streamEventPools) {
            if (eventPool != null) continue;
            this.streamEventPools[i] = streamEventPool;
            break;
        }
    }

    @Override
    public void init() {
        int nextLength = this.streamEventConverters.length;
        for (int i = 0; i < nextLength; ++i) {
            StreamEventConverter streamEventConverter = this.streamEventConverters[i];
            if (streamEventConverter != null) continue;
            this.streamEventConverters[i] = StreamEventConverterFactory.constructEventConverter(this.metaStreamEvents[i]);
            break;
        }
    }

    public static ThreadLocal<ReturnEventHolder> getMultiProcessReturn() {
        return multiProcessReturn;
    }

    public void setOutputRateLimiter(OutputRateLimiter outputRateLimiter) {
        this.outputRateLimiter = outputRateLimiter;
    }

    public class ReturnEventHolder {
        ComplexEventChunk complexEventChunk;

        public void setReturnEvents(ComplexEventChunk complexEventChunk) {
            this.complexEventChunk = new ComplexEventChunk(complexEventChunk.isBatch());
            this.complexEventChunk.add(complexEventChunk.getFirst());
        }
    }
}

