/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.snapshot;

import org.apache.log4j.Logger;
import org.wso2.siddhi.core.exception.NoPersistenceStoreException;
import org.wso2.siddhi.core.util.persistence.IncrementalPersistenceStore;
import org.wso2.siddhi.core.util.persistence.util.IncrementalSnapshotInfo;

public class AsyncIncrementalSnapshotPersistor
implements Runnable {
    private static final Logger log = Logger.getLogger(AsyncIncrementalSnapshotPersistor.class);
    private byte[] snapshots;
    private IncrementalPersistenceStore incrementalPersistenceStore;
    private IncrementalSnapshotInfo snapshotInfo;

    public AsyncIncrementalSnapshotPersistor(byte[] snapshots, IncrementalPersistenceStore incrementalPersistenceStore, IncrementalSnapshotInfo snapshotInfo) {
        if (incrementalPersistenceStore == null) {
            throw new NoPersistenceStoreException("No incremental persistence store assigned for siddhi app '" + snapshotInfo.getSiddhiAppId() + "'");
        }
        this.snapshots = snapshots;
        this.incrementalPersistenceStore = incrementalPersistenceStore;
        this.snapshotInfo = snapshotInfo;
    }

    public String getRevision() {
        return this.snapshotInfo.getRevision();
    }

    @Override
    public void run() {
        if (this.incrementalPersistenceStore != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Persisting...");
            }
            this.incrementalPersistenceStore.save(this.snapshotInfo, this.snapshots);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Persisted.");
            }
        } else {
            throw new NoPersistenceStoreException("No persistence store assigned for siddhi app " + this.snapshotInfo.getSiddhiAppId());
        }
    }
}

