/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.input;

import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputProcessor;

public class InputHandler {
    private static final Logger log = Logger.getLogger(InputHandler.class);
    protected String streamId;
    protected int streamIndex;
    protected InputProcessor inputProcessor;
    protected SiddhiAppContext siddhiAppContext;
    protected InputProcessor pausedInputPublisher;

    public InputHandler(String streamId, int streamIndex, InputProcessor inputProcessor, SiddhiAppContext siddhiAppContext) {
        this.streamId = streamId;
        this.streamIndex = streamIndex;
        this.inputProcessor = inputProcessor;
        this.siddhiAppContext = siddhiAppContext;
        this.pausedInputPublisher = this.inputProcessor;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void send(Object[] data) throws InterruptedException {
        if (this.inputProcessor != null) {
            this.inputProcessor.send(System.currentTimeMillis(), data, this.streamIndex);
        }
    }

    public void send(long timestamp, Object[] data) throws InterruptedException {
        if (this.siddhiAppContext.isPlayback()) {
            this.siddhiAppContext.getTimestampGenerator().setCurrentTimestamp(timestamp);
        }
        if (this.inputProcessor != null) {
            this.inputProcessor.send(timestamp, data, this.streamIndex);
        }
    }

    public void send(Event event) throws InterruptedException {
        if (this.siddhiAppContext.isPlayback()) {
            this.siddhiAppContext.getTimestampGenerator().setCurrentTimestamp(event.getTimestamp());
        }
        if (this.inputProcessor != null) {
            this.inputProcessor.send(event, this.streamIndex);
        }
    }

    public void send(Event[] events) throws InterruptedException {
        if (this.siddhiAppContext.isPlayback() && events.length != 0) {
            this.siddhiAppContext.getTimestampGenerator().setCurrentTimestamp(events[events.length - 1].getTimestamp());
        }
        if (this.inputProcessor != null) {
            this.inputProcessor.send(events, this.streamIndex);
        }
    }

    void disconnect() {
        this.inputProcessor = null;
    }

    void resume() {
        this.inputProcessor = this.pausedInputPublisher;
    }
}

