/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.query.input.MultiProcessStreamReceiver;
import org.wso2.siddhi.core.query.output.callback.OutputCallback;
import org.wso2.siddhi.core.query.output.callback.QueryCallback;
import org.wso2.siddhi.core.util.extension.holder.EternalReferencedHolder;
import org.wso2.siddhi.core.util.lock.LockWrapper;
import org.wso2.siddhi.core.util.snapshot.Snapshotable;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;

public abstract class OutputRateLimiter
implements EternalReferencedHolder,
Snapshotable {
    protected List<QueryCallback> queryCallbacks = new ArrayList<QueryCallback>();
    protected OutputCallback outputCallback = null;
    protected SiddhiAppContext siddhiAppContext;
    protected LatencyTracker latencyTracker;
    protected LockWrapper lockWrapper;
    protected String queryName;
    private boolean hasCallBack = false;
    private String elementId;

    public void init(SiddhiAppContext siddhiAppContext, LockWrapper lockWrapper, String queryName) {
        this.siddhiAppContext = siddhiAppContext;
        this.queryName = queryName;
        if (this.outputCallback != null) {
            this.lockWrapper = lockWrapper;
        }
        if (this.elementId == null) {
            this.elementId = "OutputRateLimiter-" + siddhiAppContext.getElementIdGenerator().createNewId();
        }
        siddhiAppContext.getSnapshotService().addSnapshotable(queryName, this);
    }

    public void sendToCallBacks(ComplexEventChunk complexEventChunk) {
        MultiProcessStreamReceiver.ReturnEventHolder returnEventHolder = MultiProcessStreamReceiver.getMultiProcessReturn().get();
        if (returnEventHolder != null) {
            returnEventHolder.setReturnEvents(complexEventChunk);
            return;
        }
        if (this.lockWrapper != null) {
            this.lockWrapper.unlock();
        }
        if (this.siddhiAppContext.isStatsEnabled() && this.latencyTracker != null) {
            this.latencyTracker.markOut();
        }
        if (this.lockWrapper != null) {
            this.lockWrapper.unlock();
        }
        if (!this.queryCallbacks.isEmpty()) {
            for (QueryCallback callback : this.queryCallbacks) {
                callback.receiveStreamEvent(complexEventChunk);
            }
        }
        if (this.outputCallback != null && complexEventChunk.getFirst() != null) {
            complexEventChunk.reset();
            int noOfEvents = 0;
            while (complexEventChunk.hasNext()) {
                Object complexEvent = complexEventChunk.next();
                if (complexEvent.getType() == ComplexEvent.Type.EXPIRED) {
                    complexEvent.setType(ComplexEvent.Type.CURRENT);
                    ++noOfEvents;
                    continue;
                }
                if (complexEvent.getType() == ComplexEvent.Type.RESET) {
                    complexEventChunk.remove();
                    continue;
                }
                ++noOfEvents;
            }
            if (complexEventChunk.getFirst() != null) {
                this.outputCallback.send(complexEventChunk, noOfEvents);
            }
        }
    }

    public void addQueryCallback(QueryCallback callback) {
        this.queryCallbacks.add(callback);
        this.hasCallBack = true;
    }

    public abstract void process(ComplexEventChunk var1);

    public OutputCallback getOutputCallback() {
        return this.outputCallback;
    }

    public void setOutputCallback(OutputCallback outputCallback) {
        this.outputCallback = outputCallback;
        if (outputCallback != null) {
            this.hasCallBack = true;
        }
    }

    public boolean hasCallBack() {
        return this.hasCallBack;
    }

    public abstract OutputRateLimiter clone(String var1);

    @Override
    public String getElementId() {
        return this.elementId;
    }

    public void setLatencyTracker(LatencyTracker latencyTracker) {
        this.latencyTracker = latencyTracker;
    }
}

