/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.persistence;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.exception.CannotClearSiddhiAppStateException;
import org.wso2.siddhi.core.util.persistence.IncrementalPersistenceStore;
import org.wso2.siddhi.core.util.persistence.util.IncrementalSnapshotInfo;
import org.wso2.siddhi.core.util.persistence.util.PersistenceHelper;

public class IncrementalFileSystemPersistenceStore
implements IncrementalPersistenceStore {
    private static final Logger log = Logger.getLogger(IncrementalFileSystemPersistenceStore.class);
    private String folder;

    public IncrementalFileSystemPersistenceStore() {
    }

    public IncrementalFileSystemPersistenceStore(String storageFilePath) {
        this.folder = storageFilePath;
    }

    @Override
    public void save(IncrementalSnapshotInfo snapshotInfo, byte[] snapshot) {
        File file = new File(this.folder + File.separator + snapshotInfo.getSiddhiAppId() + File.separator + snapshotInfo.getRevision());
        try {
            Files.createParentDirs((File)file);
            Files.write((byte[])snapshot, (File)file);
            this.cleanOldRevisions(snapshotInfo);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Incremental persistence of '" + snapshotInfo.getSiddhiAppId() + "' with revision '" + snapshotInfo.getRevision() + "' persisted successfully."));
            }
        }
        catch (IOException e) {
            log.error((Object)("Cannot save the revision '" + snapshotInfo.getRevision() + "' of SiddhiApp: '" + snapshotInfo.getSiddhiAppId() + "' to the file system."), (Throwable)e);
        }
    }

    @Override
    public void setProperties(Map properties) {
    }

    @Override
    public byte[] load(IncrementalSnapshotInfo snapshotInfo) {
        File file = new File(this.folder + File.separator + snapshotInfo.getSiddhiAppId() + File.separator + snapshotInfo.getRevision());
        byte[] bytes = null;
        try {
            bytes = Files.toByteArray((File)file);
            if (log.isDebugEnabled()) {
                log.debug((Object)("State loaded for SiddhiApp '" + snapshotInfo.getSiddhiAppId() + "' revision '" + snapshotInfo.getRevision() + "' from file system."));
            }
        }
        catch (IOException e) {
            log.error((Object)("Cannot load the revision '" + snapshotInfo.getRevision() + "' of SiddhiApp '" + snapshotInfo.getSiddhiAppId() + "' from file system."), (Throwable)e);
        }
        return bytes;
    }

    @Override
    public List<IncrementalSnapshotInfo> getListOfRevisionsToLoad(long restoreTime, String siddhiAppName) {
        File dir = new File(this.folder + File.separator + siddhiAppName);
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        ArrayList<IncrementalSnapshotInfo> results = new ArrayList<IncrementalSnapshotInfo>();
        for (File file : files) {
            String fileName = file.getName();
            IncrementalSnapshotInfo snapshotInfo = PersistenceHelper.convertRevision(fileName);
            if (snapshotInfo.getTime() > restoreTime || !siddhiAppName.equals(snapshotInfo.getSiddhiAppId()) || snapshotInfo.getElementId() == null || snapshotInfo.getQueryName() == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("List of revisions to load : " + fileName));
            }
            results.add(snapshotInfo);
        }
        return results;
    }

    @Override
    public String getLastRevision(String siddhiAppName) {
        long restoreTime = -1L;
        File dir = new File(this.folder + File.separator + siddhiAppName);
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return null;
        }
        for (File file : files) {
            String fileName = file.getName();
            IncrementalSnapshotInfo snapshotInfo = PersistenceHelper.convertRevision(fileName);
            if (snapshotInfo.getTime() <= restoreTime || !siddhiAppName.equals(snapshotInfo.getSiddhiAppId()) || snapshotInfo.getElementId() == null || snapshotInfo.getQueryName() == null) continue;
            restoreTime = snapshotInfo.getTime();
        }
        if (restoreTime != -1L) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Latest revision to load: " + restoreTime + "__" + siddhiAppName));
            }
            return restoreTime + "__" + siddhiAppName;
        }
        return null;
    }

    @Override
    public void clearAllRevisions(String siddhiAppName) {
        File dir = new File(this.folder + File.separator + siddhiAppName);
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            log.info((Object)("No revisions were found to delete for the Siddhi App " + siddhiAppName));
            return;
        }
        for (File file : files) {
            if (!file.exists() || file.delete()) continue;
            log.error((Object)("file is not deleted successfully : " + file.getName()));
            throw new CannotClearSiddhiAppStateException("Persistence state file is not deleted : " + file.getName());
        }
    }

    private void cleanOldRevisions(IncrementalSnapshotInfo incrementalSnapshotInfo) {
        File dir;
        File[] files;
        if (incrementalSnapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.INCREMENT && (files = (dir = new File(this.folder + File.separator + incrementalSnapshotInfo.getSiddhiAppId())).listFiles()) != null) {
            long baseTimeStamp = incrementalSnapshotInfo.getTime();
            for (File file : files) {
                Boolean isDeleted;
                String fileName = file.getName();
                IncrementalSnapshotInfo snapshotInfo = PersistenceHelper.convertRevision(fileName);
                if (snapshotInfo.getTime() >= baseTimeStamp || !incrementalSnapshotInfo.getSiddhiAppId().equals(snapshotInfo.getSiddhiAppId()) || !incrementalSnapshotInfo.getQueryName().equals(snapshotInfo.getQueryName()) || !incrementalSnapshotInfo.getElementId().equals(snapshotInfo.getElementId())) continue;
                if (incrementalSnapshotInfo.getType() == IncrementalSnapshotInfo.SnapshotType.BASE && snapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.PERIODIC) {
                    if (!file.exists() || (isDeleted = Boolean.valueOf(file.delete())).booleanValue()) continue;
                    log.error((Object)("Error deleting old revision " + fileName));
                    continue;
                }
                if (incrementalSnapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.PERIODIC || snapshotInfo.getType() != IncrementalSnapshotInfo.SnapshotType.PERIODIC || !file.exists() || (isDeleted = Boolean.valueOf(file.delete())).booleanValue()) continue;
                log.error((Object)("Error deleting old revision " + fileName));
            }
        }
    }
}

