/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;

public class InMemoryPersistenceStore
implements PersistenceStore {
    private static final Logger log = Logger.getLogger(InMemoryPersistenceStore.class);
    Map<String, Map<String, byte[]>> persistenceMap = new HashMap<String, Map<String, byte[]>>();
    Map<String, List<String>> revisionMap = new HashMap<String, List<String>>();

    @Override
    public void save(String siddhiAppId, String revision, byte[] data) {
        Map<String, byte[]> executionPersistenceMap = this.persistenceMap.get(siddhiAppId);
        if (executionPersistenceMap == null) {
            executionPersistenceMap = new HashMap<String, byte[]>();
        }
        executionPersistenceMap.put(revision, data);
        List<String> revisionList = this.revisionMap.get(siddhiAppId);
        if (revisionList == null) {
            revisionList = new ArrayList<String>();
            this.revisionMap.put(siddhiAppId, revisionList);
        }
        if (revisionList.size() == 0 || revisionList.size() > 0 && !revision.equals(revisionList.get(revisionList.size() - 1))) {
            revisionList.add(revision);
            this.revisionMap.put(siddhiAppId, revisionList);
        }
        this.persistenceMap.put(siddhiAppId, executionPersistenceMap);
    }

    @Override
    public byte[] load(String siddhiAppId, String revision) {
        Map<String, byte[]> executionPersistenceMap = this.persistenceMap.get(siddhiAppId);
        if (executionPersistenceMap == null) {
            log.warn((Object)("Data not found for the siddhi app " + siddhiAppId));
            return null;
        }
        return executionPersistenceMap.get(revision);
    }

    @Override
    public String getLastRevision(String siddhiAppIdentifier) {
        List<String> revisionList = this.revisionMap.get(siddhiAppIdentifier);
        if (revisionList == null) {
            return null;
        }
        if (revisionList.size() > 0) {
            return revisionList.get(revisionList.size() - 1);
        }
        return null;
    }

    @Override
    public void clearAllRevisions(String siddhiAppId) {
        List<String> revisionList = this.revisionMap.remove(siddhiAppId);
        if (revisionList == null) {
            log.info((Object)("No revisions were found to delete for the Siddhi App " + siddhiAppId));
            return;
        }
        log.info((Object)("All revisions were deleted for the Siddhi App " + siddhiAppId));
    }

    @Override
    public void setProperties(Map properties) {
    }

    public void shutdown() {
        this.persistenceMap.clear();
        this.revisionMap.clear();
    }
}

