/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.statistics.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;

public class SiddhiLatencyMetric
implements LatencyTracker {
    private ThreadLocal<Timer> execLatencyTimer;
    private ThreadLocal<Timer.Context> context;
    private String metricName;

    public SiddhiLatencyMetric(String name, final MetricRegistry metricRegistry) {
        this.metricName = name;
        this.execLatencyTimer = new ThreadLocal<Timer>(){

            @Override
            protected Timer initialValue() {
                return metricRegistry.timer(SiddhiLatencyMetric.this.metricName);
            }
        };
        this.context = new ThreadLocal<Timer.Context>(){

            @Override
            protected Timer.Context initialValue() {
                return null;
            }
        };
    }

    @Override
    public void markIn() {
        if (this.context.get() != null) {
            throw new IllegalStateException("MarkIn consecutively called without calling markOut in " + this.metricName);
        }
        this.context.set(this.execLatencyTimer.get().time());
    }

    @Override
    public void markOut() {
        if (this.context.get() != null) {
            this.context.get().stop();
            this.context.set(null);
        }
    }

    @Override
    public String getName() {
        return this.metricName;
    }
}

