/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.condition;

import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.condition.ConditionExpressionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;

public class NotConditionExpressionExecutor
extends ConditionExpressionExecutor {
    private ExpressionExecutor conditionExecutor;

    public NotConditionExpressionExecutor(ExpressionExecutor conditionExecutor) {
        if (!conditionExecutor.getReturnType().equals((Object)Attribute.Type.BOOL)) {
            throw new OperationNotSupportedException("Return type of condition executor " + conditionExecutor.toString() + " should be of type BOOL. Actual Type: " + conditionExecutor.getReturnType().toString());
        }
        this.conditionExecutor = conditionExecutor;
    }

    @Override
    public Boolean execute(ComplexEvent event) {
        Boolean result = (Boolean)this.conditionExecutor.execute(event);
        if (result == Boolean.TRUE) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public ExpressionExecutor cloneExecutor(String key) {
        return new NotConditionExpressionExecutor(this.conditionExecutor.cloneExecutor(key));
    }
}

