/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.query.api.aggregation.TimePeriod;

public class IncrementalTimeConverterUtil {
    public static long getNextEmitTime(long currentTime, TimePeriod.Duration duration, String timeZone) {
        switch (duration) {
            case SECONDS: {
                return currentTime - currentTime % 1000L + 1000L;
            }
            case MINUTES: {
                return currentTime - currentTime % 60000L + 60000L;
            }
            case HOURS: {
                return currentTime - currentTime % 3600000L + 3600000L;
            }
            case DAYS: {
                return currentTime - currentTime % 86400000L + 86400000L;
            }
            case MONTHS: {
                return IncrementalTimeConverterUtil.getNextEmitTimeForMonth(currentTime, timeZone);
            }
            case YEARS: {
                return IncrementalTimeConverterUtil.getNextEmitTimeForYear(currentTime, timeZone);
            }
        }
        throw new SiddhiAppRuntimeException("Undefined duration " + duration.toString());
    }

    public static long getStartTimeOfAggregates(long currentTime, TimePeriod.Duration duration) {
        switch (duration) {
            case SECONDS: {
                return currentTime - currentTime % (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case MINUTES: {
                return currentTime - currentTime % (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case HOURS: {
                return currentTime - currentTime % (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case DAYS: {
                return currentTime - currentTime % (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case MONTHS: {
                return IncrementalTimeConverterUtil.getStartTimeOfAggregatesForMonth(currentTime);
            }
            case YEARS: {
                return IncrementalTimeConverterUtil.getStartTimeOfAggregatesForYear(currentTime);
            }
        }
        throw new SiddhiAppRuntimeException("Undefined duration " + duration.toString());
    }

    public static long getPreviousStartTime(long currentStartTime, TimePeriod.Duration duration) {
        switch (duration) {
            case SECONDS: {
                return currentStartTime - (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case MINUTES: {
                return currentStartTime - (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case HOURS: {
                return currentStartTime - (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case DAYS: {
                return currentStartTime - (long)IncrementalTimeConverterUtil.getMillisecondsPerDuration(duration);
            }
            case MONTHS: {
                return IncrementalTimeConverterUtil.getStartTimeOfPreviousMonth(currentStartTime);
            }
            case YEARS: {
                return IncrementalTimeConverterUtil.getStartTimeOfPreviousYear(currentStartTime);
            }
        }
        throw new SiddhiAppRuntimeException("Undefined duration " + duration.toString());
    }

    private static long getNextEmitTimeForMonth(long currentTime, String timeZone) {
        ZonedDateTime zonedDateTime;
        ZoneId zoneId = ZoneId.of("GMT");
        if (timeZone != null) {
            zoneId = ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone));
        }
        if ((zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), zoneId)).getMonthValue() == 12) {
            return ZonedDateTime.of(zonedDateTime.getYear() + 1, 1, 1, 0, 0, 0, 0, zoneId).toEpochSecond() * 1000L;
        }
        return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue() + 1, 1, 0, 0, 0, 0, zoneId).toEpochSecond() * 1000L;
    }

    private static long getNextEmitTimeForYear(long currentTime, String timeZone) {
        ZoneId zoneId = ZoneId.of("GMT");
        if (timeZone != null) {
            zoneId = ZoneId.ofOffset("GMT", ZoneOffset.of(timeZone));
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), zoneId);
        return ZonedDateTime.of(zonedDateTime.getYear() + 1, 1, 1, 0, 0, 0, 0, zoneId).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfAggregatesForMonth(long currentTime) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.of("GMT"));
        return ZonedDateTime.of(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), 1, 0, 0, 0, 0, ZoneId.of("GMT")).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfAggregatesForYear(long currentTime) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTime), ZoneId.of("GMT"));
        return ZonedDateTime.of(zonedDateTime.getYear(), 1, 1, 0, 0, 0, 0, ZoneId.of("GMT")).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfPreviousMonth(long currentEmitTime) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentEmitTime), ZoneId.of("GMT"));
        int givenMonth = zonedDateTime.getMonthValue();
        int givenYear = zonedDateTime.getYear();
        if (givenMonth == 1) {
            return ZonedDateTime.of(--givenYear, 12, 1, 0, 0, 0, 0, ZoneId.of("GMT")).toEpochSecond() * 1000L;
        }
        return ZonedDateTime.of(givenYear, --givenMonth, 1, 0, 0, 0, 0, ZoneId.of("GMT")).toEpochSecond() * 1000L;
    }

    private static long getStartTimeOfPreviousYear(long currentEmitTime) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentEmitTime), ZoneId.of("GMT"));
        int givenYear = zonedDateTime.getYear();
        return ZonedDateTime.of(--givenYear, 1, 1, 0, 0, 0, 0, ZoneId.of("GMT")).toEpochSecond() * 1000L;
    }

    public static int getMillisecondsPerDuration(TimePeriod.Duration duration) {
        switch (duration) {
            case SECONDS: {
                return 1000;
            }
            case MINUTES: {
                return 60000;
            }
            case HOURS: {
                return 3600000;
            }
            case DAYS: {
                return 86400000;
            }
        }
        throw new SiddhiAppRuntimeException("Cannot provide number of milliseconds per duration " + duration + ".Number of milliseconds are only define for SECONDS, MINUTES, HOURS and DAYS");
    }
}

