/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.config;

import com.lmax.disruptor.ExceptionHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.wso2.siddhi.core.config.SiddhiContext;
import org.wso2.siddhi.core.function.Script;
import org.wso2.siddhi.core.util.ElementIdGenerator;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.ThreadBarrier;
import org.wso2.siddhi.core.util.extension.holder.EternalReferencedHolder;
import org.wso2.siddhi.core.util.snapshot.SnapshotService;
import org.wso2.siddhi.core.util.statistics.StatisticsManager;
import org.wso2.siddhi.core.util.timestamp.TimestampGenerator;

public class SiddhiAppContext {
    private SiddhiContext siddhiContext = null;
    private String name;
    private boolean playback;
    private boolean enforceOrder;
    private boolean statsEnabled = false;
    private StatisticsManager statisticsManager = null;
    private ExecutorService executorService;
    private ScheduledExecutorService scheduledExecutorService;
    private List<EternalReferencedHolder> eternalReferencedHolders = Collections.synchronizedList(new LinkedList());
    private SnapshotService snapshotService;
    private ThreadBarrier threadBarrier = null;
    private TimestampGenerator timestampGenerator = null;
    private ElementIdGenerator elementIdGenerator;
    private Map<String, Script> scriptFunctionMap = new HashMap<String, Script>();
    private ExceptionHandler<Object> disruptorExceptionHandler;
    private int bufferSize;
    private String siddhiAppString;
    private List<String> includedMetrics;
    private boolean transportChannelCreationEnabled;
    private List<Scheduler> schedulerList = new ArrayList<Scheduler>();

    public SiddhiContext getSiddhiContext() {
        return this.siddhiContext;
    }

    public void setSiddhiContext(SiddhiContext siddhiContext) {
        this.siddhiContext = siddhiContext;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPlayback() {
        return this.playback;
    }

    public void setPlayback(boolean playback) {
        this.playback = playback;
    }

    public boolean isEnforceOrder() {
        return this.enforceOrder;
    }

    public void setEnforceOrder(boolean enforceOrder) {
        this.enforceOrder = enforceOrder;
    }

    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }

    public void setStatsEnabled(boolean statsEnabled) {
        this.statsEnabled = statsEnabled;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public void setStatisticsManager(StatisticsManager statisticsManager) {
        this.statisticsManager = statisticsManager;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public synchronized void addEternalReferencedHolder(EternalReferencedHolder eternalReferencedHolder) {
        this.eternalReferencedHolders.add(eternalReferencedHolder);
    }

    public List<EternalReferencedHolder> getEternalReferencedHolders() {
        return Collections.unmodifiableList(new ArrayList<EternalReferencedHolder>(this.eternalReferencedHolders));
    }

    public ThreadBarrier getThreadBarrier() {
        return this.threadBarrier;
    }

    public void setThreadBarrier(ThreadBarrier threadBarrier) {
        this.threadBarrier = threadBarrier;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public TimestampGenerator getTimestampGenerator() {
        return this.timestampGenerator;
    }

    public void setTimestampGenerator(TimestampGenerator timestampGenerator) {
        this.timestampGenerator = timestampGenerator;
    }

    public SnapshotService getSnapshotService() {
        return this.snapshotService;
    }

    public void setSnapshotService(SnapshotService snapshotService) {
        this.snapshotService = snapshotService;
    }

    public ElementIdGenerator getElementIdGenerator() {
        return this.elementIdGenerator;
    }

    public void setElementIdGenerator(ElementIdGenerator elementIdGenerator) {
        this.elementIdGenerator = elementIdGenerator;
    }

    public Script getScript(String name) {
        return this.scriptFunctionMap.get(name);
    }

    public boolean isFunctionExist(String name) {
        return this.scriptFunctionMap.get(name) != null;
    }

    public Map<String, Script> getScriptFunctionMap() {
        return this.scriptFunctionMap;
    }

    public ExceptionHandler<Object> getDisruptorExceptionHandler() {
        if (this.disruptorExceptionHandler != null) {
            return this.disruptorExceptionHandler;
        }
        return this.siddhiContext.getDefaultDisrupterExceptionHandler();
    }

    public void setDisruptorExceptionHandler(ExceptionHandler<Object> disruptorExceptionHandler) {
        this.disruptorExceptionHandler = disruptorExceptionHandler;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getSiddhiAppString() {
        return this.siddhiAppString;
    }

    public void setSiddhiAppString(String siddhiAppString) {
        this.siddhiAppString = siddhiAppString;
    }

    public void setIncludedMetrics(List<String> includedMetrics) {
        this.includedMetrics = includedMetrics;
    }

    public List<String> getIncludedMetrics() {
        return this.includedMetrics;
    }

    public boolean isTransportChannelCreationEnabled() {
        return this.transportChannelCreationEnabled;
    }

    public void setTransportChannelCreationEnabled(boolean transportChannelCreationEnabled) {
        this.transportChannelCreationEnabled = transportChannelCreationEnabled;
    }

    public void addScheduler(Scheduler scheduler) {
        this.schedulerList.add(scheduler);
    }

    public List<Scheduler> getSchedulerList() {
        return this.schedulerList;
    }
}

