/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.TimeWindowProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.core.util.snapshot.state.SnapshotStateList;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

@Extension(name="delay", namespace="", description="A delay window holds events that arrived for a given delay time period before processing them.", parameters={@Parameter(name="window.delay", description="The time period(sec, min, ms) for which  the window should delay the events.", type={DataType.INT, DataType.LONG, DataType.TIME})}, examples={@Example(syntax="define window delayWindow(symbol string, volume int) delay(1 hour);\ndefine stream purchaseStream(symbol string, volume int);\ndefine stream deliveryStream(symbol string);\ndefine stream outputStream(symbol string);\n\n@info(name='query1') \nfrom purchaseStream\nselect symbol, volume\ninsert into delayWindow;\n\n@info(name='query2') \nfrom delayWindow join deliveryStream\non delayWindow.symbol == deliveryStream.symbol\nselect delayWindow.symbol\ninsert into outputStream;", description="This will delay the events from purchaseStream for 1 hour and match them with events arrived from deliveryStream to check if delivery of the purchased item is done within 1 hour ")})
public class DelayWindowProcessor
extends TimeWindowProcessor {
    private long delayInMilliSeconds;
    private SiddhiAppContext siddhiAppContext;
    private SnapshotableStreamEventQueue delayedEventQueue;
    private volatile long lastTimestamp = Long.MIN_VALUE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
        this.delayedEventQueue = new SnapshotableStreamEventQueue(this.streamEventClonerHolder);
        if (attributeExpressionExecutors.length != 1) throw new SiddhiAppValidationException("Delay window should only have one parameter (<int|long|time> delayTime), but found " + attributeExpressionExecutors.length + " input attributes");
        if (!(attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) throw new SiddhiAppValidationException("Delay window should have constant parameter attribute but found a dynamic attribute " + attributeExpressionExecutors[0].getClass().getCanonicalName());
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.INT && attributeExpressionExecutors[0].getReturnType() != Attribute.Type.LONG) {
            throw new SiddhiAppValidationException("Delay window's parameter attribute should be either int or long, but found " + attributeExpressionExecutors[0].getReturnType());
        }
        this.delayInMilliSeconds = Long.parseLong(((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        DelayWindowProcessor delayWindowProcessor = this;
        synchronized (delayWindowProcessor) {
            while (streamEventChunk.hasNext()) {
                StreamEvent delayedEvent;
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
                this.delayedEventQueue.reset();
                while (this.delayedEventQueue.hasNext() && currentTime >= (delayedEvent = this.delayedEventQueue.next()).getTimestamp() + this.delayInMilliSeconds) {
                    this.delayedEventQueue.remove();
                    streamEventChunk.insertBeforeCurrent(delayedEvent);
                }
                if (streamEvent.getType() == ComplexEvent.Type.CURRENT) {
                    this.delayedEventQueue.add(streamEvent);
                    if (this.lastTimestamp < streamEvent.getTimestamp()) {
                        this.getScheduler().notifyAt(streamEvent.getTimestamp() + this.delayInMilliSeconds);
                        this.lastTimestamp = streamEvent.getTimestamp();
                    }
                }
                streamEventChunk.remove();
            }
            this.delayedEventQueue.reset();
        }
        if (streamEventChunk.getFirst() != null) {
            nextProcessor.process(streamEventChunk);
        }
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        return ((Operator)compiledCondition).find(matchingEvent, this.delayedEventQueue, this.streamEventCloner);
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        return OperatorParser.constructOperator(this.delayedEventQueue, condition, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, this.queryName);
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("DelayedEventQueue", this.delayedEventQueue.getSnapshot());
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.delayedEventQueue.restore((SnapshotStateList)state.get("DelayedEventQueue"));
    }
}

