/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.transport;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.exception.NoSuchAttributeException;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public class TemplateBuilder {
    private static final Pattern DYNAMIC_PATTERN = Pattern.compile("(\\{\\{[^{}]*\\}\\})|[{}]");
    private MessageFormat messageFormat;
    private boolean isObjectMessage = false;
    private int objectIndex = -1;

    public TemplateBuilder(StreamDefinition streamDefinition, String template) {
        this.parse(streamDefinition, template);
    }

    public static Map<String, Object> convert(Event event, Map<String, TemplateBuilder> converterMap) {
        HashMap<String, Object> mapped = new HashMap<String, Object>();
        for (Map.Entry<String, TemplateBuilder> entry : converterMap.entrySet()) {
            mapped.put(entry.getKey(), entry.getValue().build(event));
        }
        return mapped;
    }

    public static Object[] convert(Event event, TemplateBuilder[] templateBuilders) {
        Object[] mapped = new String[templateBuilders.length];
        int i = 0;
        for (TemplateBuilder templateBuilder : templateBuilders) {
            mapped[i] = templateBuilder.build(event);
            ++i;
        }
        return mapped;
    }

    public Object build(Event event) {
        if (this.isObjectMessage) {
            return event.getData()[this.objectIndex];
        }
        return this.messageFormat.format(event.getData());
    }

    public Object build(ComplexEvent complexEvent) {
        if (this.isObjectMessage) {
            return complexEvent.getOutputData()[this.objectIndex];
        }
        return this.messageFormat.format(complexEvent.getOutputData());
    }

    private void parse(StreamDefinition streamDefinition, String template) {
        if (Arrays.asList(streamDefinition.getAttributeNameArray()).contains(template.trim())) {
            this.objectIndex = streamDefinition.getAttributePosition(template.trim());
            this.isObjectMessage = true;
        } else {
            if (template.matches("^`[^\\s]*`$")) {
                template = template.replaceAll("^`|`$", "");
            }
            this.messageFormat = this.parseTextMessage(streamDefinition, template);
        }
    }

    private MessageFormat parseTextMessage(StreamDefinition streamDefinition, String template) {
        List<String> attributes = Arrays.asList(streamDefinition.getAttributeNameArray());
        StringBuffer result = new StringBuffer();
        Matcher m = DYNAMIC_PATTERN.matcher(template);
        while (m.find()) {
            if (m.group(1) != null) {
                int attrIndex = attributes.indexOf(m.group(1).replaceAll("\\p{Ps}", "").replaceAll("\\p{Pe}", ""));
                if (attrIndex >= 0) {
                    m.appendReplacement(result, String.format("{%s}", attrIndex));
                    continue;
                }
                throw new NoSuchAttributeException(String.format("Attribute : %s does not exist in %s.", m.group(1), streamDefinition));
            }
            m.appendReplacement(result, "' " + m.group() + "' ");
        }
        m.appendTail(result);
        return new MessageFormat(result.toString());
    }

    public boolean isObjectMessage() {
        return this.isObjectMessage;
    }
}

