/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.aggregation;

import java.util.List;
import org.wso2.siddhi.core.aggregation.AggregationRuntime;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.MetaStreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.incremental.IncrementalUnixTimeFunctionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.core.util.statistics.ThroughputTracker;

public class IncrementalAggregationProcessor
implements Processor {
    private final List<ExpressionExecutor> incomingExpressionExecutors;
    private final StreamEventPool streamEventPool;
    private final LatencyTracker latencyTrackerInsert;
    private final ThroughputTracker throughputTrackerInsert;
    private SiddhiAppContext siddhiAppContext;
    private AggregationRuntime aggregationRuntime;
    private boolean isFirstEventArrived = false;

    public IncrementalAggregationProcessor(AggregationRuntime aggregationRuntime, List<ExpressionExecutor> incomingExpressionExecutors, MetaStreamEvent processedMetaStreamEvent, LatencyTracker latencyTrackerInsert, ThroughputTracker throughputTrackerInsert, SiddhiAppContext siddhiAppContext) {
        this.aggregationRuntime = aggregationRuntime;
        this.incomingExpressionExecutors = incomingExpressionExecutors;
        this.streamEventPool = new StreamEventPool(processedMetaStreamEvent, 5);
        this.latencyTrackerInsert = latencyTrackerInsert;
        this.throughputTrackerInsert = throughputTrackerInsert;
        this.siddhiAppContext = siddhiAppContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StreamEvent> streamEventChunk = new ComplexEventChunk<StreamEvent>(complexEventChunk.isBatch());
        try {
            int noOfEvents = 0;
            if (this.latencyTrackerInsert != null && this.siddhiAppContext.isStatsEnabled()) {
                this.latencyTrackerInsert.markIn();
            }
            while (complexEventChunk.hasNext()) {
                Object complexEvent = complexEventChunk.next();
                if (!this.isFirstEventArrived) {
                    this.aggregationRuntime.recreateInMemoryData(true);
                    this.isFirstEventArrived = true;
                }
                StreamEvent borrowedEvent = this.streamEventPool.borrowEvent();
                for (int i = 0; i < this.incomingExpressionExecutors.size(); ++i) {
                    ExpressionExecutor expressionExecutor = this.incomingExpressionExecutors.get(i);
                    Object outputData = expressionExecutor.execute((ComplexEvent)complexEvent);
                    if (expressionExecutor instanceof IncrementalUnixTimeFunctionExecutor && outputData == null) {
                        throw new SiddhiAppRuntimeException("Cannot retrieve the timestamp of event");
                    }
                    borrowedEvent.setOutputData(outputData, i);
                }
                streamEventChunk.add(borrowedEvent);
                ++noOfEvents;
            }
            this.aggregationRuntime.processEvents(streamEventChunk);
            if (this.throughputTrackerInsert != null && this.siddhiAppContext.isStatsEnabled()) {
                this.throughputTrackerInsert.eventsIn(noOfEvents);
            }
        }
        finally {
            if (this.latencyTrackerInsert != null && this.siddhiAppContext.isStatsEnabled()) {
                this.latencyTrackerInsert.markOut();
            }
        }
    }

    @Override
    public Processor getNextProcessor() {
        return null;
    }

    @Override
    public void setNextProcessor(Processor processor) {
        throw new SiddhiAppCreationException("IncrementalAggregationProcessor does not support any next processor");
    }

    @Override
    public void setToLast(Processor processor) {
        throw new SiddhiAppCreationException("IncrementalAggregationProcessor does not support any next/last processor");
    }

    @Override
    public Processor cloneProcessor(String key) {
        throw new SiddhiAppCreationException("IncrementalAggregationProcessor cannot be cloned");
    }
}

