/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.collection.operator;

import java.util.Map;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.table.InMemoryCompiledUpdateSet;
import org.wso2.siddhi.core.util.collection.AddingStreamEventExtractor;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.Operator;

public class SnapshotableEventQueueOperator
implements Operator {
    protected ExpressionExecutor expressionExecutor;
    protected int storeEventPosition;

    public SnapshotableEventQueueOperator(ExpressionExecutor expressionExecutor, int storeEventPosition) {
        this.expressionExecutor = expressionExecutor;
        this.storeEventPosition = storeEventPosition;
    }

    @Override
    public CompiledCondition cloneCompilation(String key) {
        return new SnapshotableEventQueueOperator(this.expressionExecutor.cloneExecutor(key), this.storeEventPosition);
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, Object storeEvents, StreamEventCloner storeEventCloner) {
        SnapshotableStreamEventQueue storeEventQueue = (SnapshotableStreamEventQueue)storeEvents;
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
        storeEventQueue.reset();
        while (storeEventQueue.hasNext()) {
            StreamEvent storeEvent = storeEventQueue.next();
            matchingEvent.setEvent(this.storeEventPosition, storeEvent);
            if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
                returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
            }
            matchingEvent.setEvent(this.storeEventPosition, null);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(StateEvent matchingEvent, Object storeEvents) {
        SnapshotableStreamEventQueue storeEventQueue = (SnapshotableStreamEventQueue)storeEvents;
        try {
            storeEventQueue.reset();
            while (storeEventQueue.hasNext()) {
                StreamEvent storeEvent = storeEventQueue.next();
                matchingEvent.setEvent(this.storeEventPosition, storeEvent);
                if (!((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            matchingEvent.setEvent(this.storeEventPosition, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(ComplexEventChunk<StateEvent> deletingEventChunk, Object storeEvents) {
        SnapshotableStreamEventQueue storeEventQueue = (SnapshotableStreamEventQueue)storeEvents;
        deletingEventChunk.reset();
        while (deletingEventChunk.hasNext()) {
            StateEvent deletingEvent = (StateEvent)deletingEventChunk.next();
            try {
                storeEventQueue.reset();
                while (storeEventQueue.hasNext()) {
                    StreamEvent storeEvent = storeEventQueue.next();
                    deletingEvent.setEvent(this.storeEventPosition, storeEvent);
                    if (!((Boolean)this.expressionExecutor.execute(deletingEvent)).booleanValue()) continue;
                    storeEventQueue.remove();
                }
            }
            finally {
                deletingEvent.setEvent(this.storeEventPosition, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ComplexEventChunk<StateEvent> updatingEventChunk, Object storeEvents, InMemoryCompiledUpdateSet compiledUpdateSet) {
        SnapshotableStreamEventQueue storeEventQueue = (SnapshotableStreamEventQueue)storeEvents;
        updatingEventChunk.reset();
        while (updatingEventChunk.hasNext()) {
            StateEvent updatingEvent = (StateEvent)updatingEventChunk.next();
            try {
                storeEventQueue.reset();
                while (storeEventQueue.hasNext()) {
                    StreamEvent storeEvent = storeEventQueue.next();
                    updatingEvent.setEvent(this.storeEventPosition, storeEvent);
                    if (!((Boolean)this.expressionExecutor.execute(updatingEvent)).booleanValue()) continue;
                    for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                        Object value = entry.getValue().execute(updatingEvent);
                        storeEvent.setOutputData(value, entry.getKey());
                    }
                    storeEventQueue.overwrite(storeEvent);
                }
            }
            finally {
                updatingEvent.setEvent(this.storeEventPosition, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StreamEvent> tryUpdate(ComplexEventChunk<StateEvent> updatingOrAddingEventChunk, Object storeEvents, InMemoryCompiledUpdateSet compiledUpdateSet, AddingStreamEventExtractor addingStreamEventExtractor) {
        SnapshotableStreamEventQueue storeEventQueue = (SnapshotableStreamEventQueue)storeEvents;
        updatingOrAddingEventChunk.reset();
        ComplexEventChunk<StreamEvent> failedEventChunk = new ComplexEventChunk<StreamEvent>(updatingOrAddingEventChunk.isBatch());
        while (updatingOrAddingEventChunk.hasNext()) {
            StateEvent overwritingOrAddingEvent = (StateEvent)updatingOrAddingEventChunk.next();
            try {
                boolean updated = false;
                storeEventQueue.reset();
                while (storeEventQueue.hasNext()) {
                    StreamEvent storeEvent = storeEventQueue.next();
                    overwritingOrAddingEvent.setEvent(this.storeEventPosition, storeEvent);
                    if (!((Boolean)this.expressionExecutor.execute(overwritingOrAddingEvent)).booleanValue()) continue;
                    for (Map.Entry<Integer, ExpressionExecutor> entry : compiledUpdateSet.getExpressionExecutorMap().entrySet()) {
                        storeEvent.setOutputData(entry.getValue().execute(overwritingOrAddingEvent), entry.getKey());
                    }
                    storeEventQueue.overwrite(storeEvent);
                    updated = true;
                }
                if (updated) continue;
                failedEventChunk.add(addingStreamEventExtractor.getAddingStreamEvent(overwritingOrAddingEvent));
            }
            finally {
                overwritingOrAddingEvent.setEvent(this.storeEventPosition, null);
            }
        }
        return failedEventChunk;
    }
}

