/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input.stream.single;

import java.util.ArrayList;
import java.util.List;
import org.wso2.siddhi.core.event.MetaComplexEvent;
import org.wso2.siddhi.core.query.input.ProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.StreamRuntime;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveProcessor;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.query.selector.QuerySelector;

public class SingleStreamRuntime
implements StreamRuntime {
    private Processor processorChain;
    private MetaComplexEvent metaComplexEvent;
    private ProcessStreamReceiver processStreamReceiver;

    public SingleStreamRuntime(ProcessStreamReceiver processStreamReceiver, Processor processorChain, MetaComplexEvent metaComplexEvent) {
        this.processStreamReceiver = processStreamReceiver;
        this.processorChain = processorChain;
        this.metaComplexEvent = metaComplexEvent;
    }

    public Processor getProcessorChain() {
        return this.processorChain;
    }

    public void setProcessorChain(Processor processorChain) {
        this.processorChain = processorChain;
    }

    public ProcessStreamReceiver getProcessStreamReceiver() {
        return this.processStreamReceiver;
    }

    public void setProcessStreamReceiver(ProcessStreamReceiver processStreamReceiver) {
        this.processStreamReceiver = processStreamReceiver;
    }

    @Override
    public List<SingleStreamRuntime> getSingleStreamRuntimes() {
        ArrayList<SingleStreamRuntime> list = new ArrayList<SingleStreamRuntime>(1);
        list.add(this);
        return list;
    }

    @Override
    public StreamRuntime clone(String key) {
        ProcessStreamReceiver clonedProcessStreamReceiver = this.processStreamReceiver.clone(key);
        EntryValveProcessor entryValveProcessor = null;
        Processor clonedProcessorChain = null;
        if (this.processorChain != null) {
            if (!(this.processorChain instanceof QuerySelector) && !(this.processorChain instanceof OutputRateLimiter) && (clonedProcessorChain = this.processorChain.cloneProcessor(key)) instanceof EntryValveProcessor) {
                entryValveProcessor = (EntryValveProcessor)clonedProcessorChain;
            }
            for (Processor processor = this.processorChain.getNextProcessor(); processor != null; processor = processor.getNextProcessor()) {
                if (processor instanceof QuerySelector || processor instanceof OutputRateLimiter) continue;
                Processor clonedProcessor = processor.cloneProcessor(key);
                clonedProcessorChain.setToLast(clonedProcessor);
                if (clonedProcessor instanceof EntryValveProcessor) {
                    entryValveProcessor = (EntryValveProcessor)clonedProcessor;
                    continue;
                }
                if (!(clonedProcessor instanceof SchedulingProcessor)) continue;
                SchedulingProcessor schedulingProcessor = (SchedulingProcessor)clonedProcessor;
                schedulingProcessor.setScheduler(((SchedulingProcessor)processor).getScheduler().clone(key, entryValveProcessor));
            }
        }
        return new SingleStreamRuntime(clonedProcessStreamReceiver, clonedProcessorChain, this.metaComplexEvent);
    }

    @Override
    public void setCommonProcessor(Processor commonProcessor) {
        if (this.processorChain == null) {
            this.processStreamReceiver.setNext(commonProcessor);
        } else {
            this.processStreamReceiver.setNext(this.processorChain);
            this.processorChain.setToLast(commonProcessor);
        }
    }

    @Override
    public MetaComplexEvent getMetaComplexEvent() {
        return this.metaComplexEvent;
    }
}

