/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.output.sink;

import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.output.sink.SinkListener;
import org.wso2.siddhi.core.stream.output.sink.SinkMapper;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.core.util.transport.TemplateBuilder;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

@Extension(name="passThrough", namespace="sinkMapper", description="Pass-through mapper passed events (Event[]) through without any mapping or modifications.", examples={@Example(syntax="@sink(type='inMemory', @map(type='passThrough'))\ndefine stream BarStream (symbol string, price float, volume long);", description="In the following example BarStream uses passThrough outputmapper which emit Siddhi event directly without any transformation into sink.")})
public class PassThroughSinkMapper
extends SinkMapper {
    @Override
    public String[] getSupportedDynamicOptions() {
        return new String[0];
    }

    @Override
    public void init(StreamDefinition streamDefinition, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, ConfigReader mapperConfigReader, SiddhiAppContext siddhiAppContext) {
    }

    @Override
    public Class[] getOutputEventClasses() {
        return new Class[]{Event[].class, Event.class};
    }

    @Override
    public void mapAndSend(Event[] events, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, SinkListener sinkListener) {
        sinkListener.publish(events);
    }

    @Override
    public void mapAndSend(Event event, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, SinkListener sinkListener) {
        sinkListener.publish(event);
    }
}

