/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.function;

import java.util.Map;
import java.util.Set;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="sizeOfSet", namespace="", description="Returns the size of an object of type java.util.Set.", parameters={@Parameter(name="set", description="The set object. This parameter should be of type java.util.Set. A set object may be created by the 'set' attribute aggregator in Siddhi. ", type={DataType.OBJECT})}, returnAttributes={@ReturnAttribute(description="The size of the set.", type={DataType.INT})}, examples={@Example(syntax="from stockStream \nselect initSet(symbol) as initialSet \ninsert into initStream; \n\n;from initStream#window.timeBatch(10 sec) \nselect union(initialSet) as distinctSymbols \ninsert into distinctStockStream; \n\nfrom distinctStockStream \nselect sizeOfSet(distinctSymbols) sizeOfSymbolSet \ninsert into sizeStream;", description="The sizeStream stream will output the number of distinct stock symbols received during a sliding window of 10 seconds.")})
public class SizeOfSetFunctionExecutor
extends FunctionExecutor {
    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("sizeOfSet() function has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.OBJECT) {
            throw new OperationNotSupportedException("Parameter given for sizeOfSet() function has to be of type object, but found: " + attributeExpressionExecutors[0].getReturnType());
        }
    }

    @Override
    protected Object execute(Object[] data) {
        return null;
    }

    @Override
    protected Object execute(Object data) {
        if (data == null) {
            return 0;
        }
        if (!(data instanceof Set)) {
            throw new SiddhiAppRuntimeException("Input to sizeOfSet() function should be an instance of java.util.Set, but found " + data.getClass().getCanonicalName());
        }
        Set set = (Set)data;
        return set.size();
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.INT;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }
}

