/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.persistence.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.PersistenceStoreException;
import org.wso2.siddhi.core.util.persistence.util.IncrementalSnapshotInfo;
import org.wso2.siddhi.core.util.snapshot.AsyncIncrementalSnapshotPersistor;
import org.wso2.siddhi.core.util.snapshot.AsyncSnapshotPersistor;
import org.wso2.siddhi.core.util.snapshot.IncrementalSnapshot;
import org.wso2.siddhi.core.util.snapshot.PersistenceReference;

public final class PersistenceHelper {
    public static IncrementalSnapshotInfo convertRevision(String revision) {
        String[] items = revision.split("__");
        if (items.length == 5) {
            return new IncrementalSnapshotInfo(items[1], items[2], items[3], Long.parseLong(items[0]), IncrementalSnapshotInfo.SnapshotType.valueOf(items[4]));
        }
        if (items.length == 2) {
            return new IncrementalSnapshotInfo(items[1], null, null, Long.parseLong(items[0]), IncrementalSnapshotInfo.SnapshotType.PERIODIC);
        }
        throw new PersistenceStoreException("Invalid revision found '" + revision + "'!");
    }

    public static PersistenceReference persist(byte[] serializeObj, SiddhiAppContext siddhiAppContext) {
        long revisionTime = System.currentTimeMillis();
        AsyncSnapshotPersistor asyncSnapshotPersistor = new AsyncSnapshotPersistor(serializeObj, siddhiAppContext.getSiddhiContext().getPersistenceStore(), siddhiAppContext.getName(), revisionTime);
        Future<?> future = siddhiAppContext.getExecutorService().submit(asyncSnapshotPersistor);
        return new PersistenceReference(future, asyncSnapshotPersistor.getRevision());
    }

    public static PersistenceReference persist(IncrementalSnapshot serializeObj, SiddhiAppContext siddhiAppContext) {
        Map<String, Map<String, byte[]>> incrementalState;
        Map<String, Map<String, byte[]>> incrementalStateBase;
        long revisionTime = System.currentTimeMillis();
        ArrayList<Future> incrementalFutures = new ArrayList<Future>();
        Map<String, Map<String, byte[]>> periodicStateBase = serializeObj.getPeriodicState();
        if (periodicStateBase != null) {
            periodicStateBase.forEach((queryName, value) -> value.forEach((elementId, value1) -> {
                AsyncIncrementalSnapshotPersistor asyncIncrementSnapshotPersistor = new AsyncIncrementalSnapshotPersistor((byte[])value1, siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore(), new IncrementalSnapshotInfo(siddhiAppContext.getName(), (String)queryName, (String)elementId, revisionTime, IncrementalSnapshotInfo.SnapshotType.PERIODIC));
                Future<?> future = siddhiAppContext.getExecutorService().submit(asyncIncrementSnapshotPersistor);
                incrementalFutures.add(future);
            }));
        }
        if ((incrementalStateBase = serializeObj.getIncrementalStateBase()) != null) {
            incrementalStateBase.forEach((queryName, value) -> value.forEach((elementId, value1) -> {
                AsyncIncrementalSnapshotPersistor asyncIncrementSnapshotPersistor = new AsyncIncrementalSnapshotPersistor((byte[])value1, siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore(), new IncrementalSnapshotInfo(siddhiAppContext.getName(), (String)queryName, (String)elementId, revisionTime, IncrementalSnapshotInfo.SnapshotType.BASE));
                Future<?> future = siddhiAppContext.getExecutorService().submit(asyncIncrementSnapshotPersistor);
                incrementalFutures.add(future);
            }));
        }
        if ((incrementalState = serializeObj.getIncrementalState()) != null) {
            incrementalState.forEach((queryName, value) -> value.forEach((elementId, value1) -> {
                AsyncIncrementalSnapshotPersistor asyncIncrementSnapshotPersistor = new AsyncIncrementalSnapshotPersistor((byte[])value1, siddhiAppContext.getSiddhiContext().getIncrementalPersistenceStore(), new IncrementalSnapshotInfo(siddhiAppContext.getName(), (String)queryName, (String)elementId, revisionTime, IncrementalSnapshotInfo.SnapshotType.INCREMENT));
                Future<?> future = siddhiAppContext.getExecutorService().submit(asyncIncrementSnapshotPersistor);
                incrementalFutures.add(future);
            }));
        }
        return new PersistenceReference(incrementalFutures, revisionTime + "__" + siddhiAppContext.getName());
    }
}

