/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.executor.incremental;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.regex.Pattern;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

public class IncrementalTimeGetTimeZone
extends FunctionExecutor {
    private static Pattern nonGmtRegexPattern = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:][0-9]{2}[:][0-9]{2}\\s[+-][0-9]{2}[:][0-9]{2}");
    private static Pattern gmtRegexPattern = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}\\s[0-9]{2}[:][0-9]{2}[:][0-9]{2}");

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 0 && attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("incrementalAggregator:getTimeZone() function accepts zero or one argument, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors.length == 1 && attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Time zone can be retrieved, only from string values, but found " + attributeExpressionExecutors[0].getReturnType());
        }
    }

    @Override
    protected Object execute(Object[] data) {
        return null;
    }

    @Override
    protected Object execute(Object data) {
        if (data == null) {
            return ZoneOffset.systemDefault().getRules().getOffset(Instant.now()).getId();
        }
        return IncrementalTimeGetTimeZone.getTimeZone(data.toString());
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.STRING;
    }

    @Override
    public Map<String, Object> currentState() {
        return null;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
    }

    public static String getTimeZone(String stringTimeStamp) {
        if (gmtRegexPattern.matcher(stringTimeStamp = stringTimeStamp.trim()).matches()) {
            return "+00:00";
        }
        if (nonGmtRegexPattern.matcher(stringTimeStamp).matches()) {
            String[] dateTimeZone = stringTimeStamp.split(" ");
            return dateTimeZone[2];
        }
        throw new SiddhiAppRuntimeException("Timestamp " + stringTimeStamp + "doesn't match " + "the supported formats <yyyy>-<MM>-<dd> <HH>:<mm>:<ss> (for GMT time zone) or " + "<yyyy>-<MM>-<dd> <HH>:<mm>:<ss> <Z> (for non GMT time zone). The ISO 8601 UTC offset must be " + "provided for <Z> (ex. +05:30, -11:00");
    }
}

