/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.config;

import com.lmax.disruptor.ExceptionHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.StatisticsConfiguration;
import org.wso2.siddhi.core.exception.PersistenceStoreException;
import org.wso2.siddhi.core.stream.input.source.SourceHandlerManager;
import org.wso2.siddhi.core.stream.output.sink.SinkHandlerManager;
import org.wso2.siddhi.core.table.record.RecordTableHandlerManager;
import org.wso2.siddhi.core.util.SiddhiExtensionLoader;
import org.wso2.siddhi.core.util.config.ConfigManager;
import org.wso2.siddhi.core.util.config.InMemoryConfigManager;
import org.wso2.siddhi.core.util.extension.holder.AbstractExtensionHolder;
import org.wso2.siddhi.core.util.persistence.IncrementalPersistenceStore;
import org.wso2.siddhi.core.util.persistence.PersistenceStore;
import org.wso2.siddhi.core.util.statistics.metrics.SiddhiMetricsFactory;

public class SiddhiContext {
    private static final Logger log = Logger.getLogger(SiddhiContext.class);
    private ExceptionHandler<Object> defaultDisrupterExceptionHandler;
    private Map<String, Class> siddhiExtensions = new HashMap<String, Class>();
    private PersistenceStore persistenceStore = null;
    private IncrementalPersistenceStore incrementalPersistenceStore = null;
    private ConcurrentHashMap<String, DataSource> siddhiDataSources;
    private StatisticsConfiguration statisticsConfiguration;
    private ConcurrentHashMap<Class, AbstractExtensionHolder> extensionHolderMap;
    private ConfigManager configManager = null;
    private SinkHandlerManager sinkHandlerManager = null;
    private SourceHandlerManager sourceHandlerManager = null;
    private RecordTableHandlerManager recordTableHandlerManager = null;

    public SiddhiContext() {
        SiddhiExtensionLoader.loadSiddhiExtensions(this.siddhiExtensions);
        this.siddhiDataSources = new ConcurrentHashMap();
        this.statisticsConfiguration = new StatisticsConfiguration(new SiddhiMetricsFactory());
        this.extensionHolderMap = new ConcurrentHashMap();
        this.configManager = new InMemoryConfigManager();
        this.defaultDisrupterExceptionHandler = new ExceptionHandler<Object>(){

            public void handleEventException(Throwable throwable, long l, Object event) {
                log.error((Object)("Disruptor encountered an error processing [sequence: " + l + ", event: " + event.toString() + "]"), throwable);
            }

            public void handleOnStartException(Throwable throwable) {
                log.error((Object)"Disruptor encountered an error on start", throwable);
            }

            public void handleOnShutdownException(Throwable throwable) {
                log.error((Object)"Disruptor encountered an error on shutdown", throwable);
            }
        };
    }

    public Map<String, Class> getSiddhiExtensions() {
        return this.siddhiExtensions;
    }

    public synchronized PersistenceStore getPersistenceStore() {
        return this.persistenceStore;
    }

    public synchronized void setPersistenceStore(PersistenceStore persistenceStore) {
        if (this.incrementalPersistenceStore != null) {
            throw new PersistenceStoreException("Only one type of persistence store can exist. Incremental persistence store '" + this.incrementalPersistenceStore.getClass().getName() + "' already registered!");
        }
        this.persistenceStore = persistenceStore;
    }

    public synchronized IncrementalPersistenceStore getIncrementalPersistenceStore() {
        return this.incrementalPersistenceStore;
    }

    public synchronized void setIncrementalPersistenceStore(IncrementalPersistenceStore incrementalPersistenceStore) {
        if (this.persistenceStore != null) {
            throw new PersistenceStoreException("Only one type of persistence store can exist. Persistence store '" + this.persistenceStore.getClass().getName() + "' already registered!");
        }
        this.incrementalPersistenceStore = incrementalPersistenceStore;
    }

    public void setConfigManager(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public DataSource getSiddhiDataSource(String dataSourceName) {
        if (dataSourceName != null) {
            return this.siddhiDataSources.get(dataSourceName);
        }
        return null;
    }

    public void addSiddhiDataSource(String dataSourceName, DataSource dataSource) {
        this.siddhiDataSources.put(dataSourceName, dataSource);
    }

    public StatisticsConfiguration getStatisticsConfiguration() {
        return this.statisticsConfiguration;
    }

    public void setStatisticsConfiguration(StatisticsConfiguration statisticsConfiguration) {
        this.statisticsConfiguration = statisticsConfiguration;
    }

    public ConcurrentHashMap<Class, AbstractExtensionHolder> getExtensionHolderMap() {
        return this.extensionHolderMap;
    }

    public ExceptionHandler<Object> getDefaultDisrupterExceptionHandler() {
        return this.defaultDisrupterExceptionHandler;
    }

    public SinkHandlerManager getSinkHandlerManager() {
        return this.sinkHandlerManager;
    }

    public void setSinkHandlerManager(SinkHandlerManager sinkHandlerManager) {
        this.sinkHandlerManager = sinkHandlerManager;
    }

    public SourceHandlerManager getSourceHandlerManager() {
        return this.sourceHandlerManager;
    }

    public void setSourceHandlerManager(SourceHandlerManager sourceHandlerManager) {
        this.sourceHandlerManager = sourceHandlerManager;
    }

    public RecordTableHandlerManager getRecordTableHandlerManager() {
        return this.recordTableHandlerManager;
    }

    public void setRecordTableHandlerManager(RecordTableHandlerManager recordTableHandlerManager) {
        this.recordTableHandlerManager = recordTableHandlerManager;
    }
}

