/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.input;

import java.util.List;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.input.InputProcessor;
import org.wso2.siddhi.core.util.ThreadBarrier;

public class InputEntryValve
implements InputProcessor {
    private ThreadBarrier barrier;
    private InputProcessor inputProcessor;

    public InputEntryValve(SiddhiAppContext siddhiAppContext, InputProcessor inputProcessor) {
        this.barrier = siddhiAppContext.getThreadBarrier();
        this.inputProcessor = inputProcessor;
    }

    @Override
    public void send(Event event, int streamIndex) {
        this.barrier.pass();
        this.inputProcessor.send(event, streamIndex);
    }

    @Override
    public void send(Event[] events, int streamIndex) {
        this.barrier.pass();
        this.inputProcessor.send(events, streamIndex);
    }

    @Override
    public void send(List<Event> events, int streamIndex) {
        this.barrier.pass();
        this.inputProcessor.send(events, streamIndex);
    }

    @Override
    public void send(long timestamp, Object[] data, int streamIndex) {
        this.barrier.pass();
        this.inputProcessor.send(timestamp, data, streamIndex);
    }
}

