/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="count", namespace="", description="Returns the count of all the events.", parameters={}, returnAttributes={@ReturnAttribute(description="Returns the event count as a long.", type={DataType.LONG})}, examples={@Example(syntax="from fooStream#window.timeBatch(10 sec)\nselect count() as count\ninsert into barStream;", description="This will return the count of all the events for time batch in 10 seconds.")})
public class CountAttributeAggregator
extends AttributeAggregator {
    private static Attribute.Type type = Attribute.Type.LONG;
    private long count = 0L;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
    }

    @Override
    public Attribute.Type getReturnType() {
        return type;
    }

    @Override
    public Object processAdd(Object data) {
        ++this.count;
        return this.count;
    }

    @Override
    public Object processAdd(Object[] data) {
        ++this.count;
        return this.count;
    }

    @Override
    public Object processRemove(Object data) {
        --this.count;
        return this.count;
    }

    @Override
    public Object processRemove(Object[] data) {
        --this.count;
        return this.count;
    }

    @Override
    public Object reset() {
        this.count = 0L;
        return this.count;
    }

    @Override
    public boolean canDestroy() {
        return this.count == 0L;
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("Count", this.count);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.count = (Long)state.get("Count");
    }
}

