/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.query.output.ratelimit.OutputRateLimiter;

public class AllPerEventOutputRateLimiter
extends OutputRateLimiter {
    private final Integer value;
    private String id;
    private volatile int counter = 0;
    private ComplexEventChunk<ComplexEvent> allComplexEventChunk;

    public AllPerEventOutputRateLimiter(String id, Integer value) {
        this.id = id;
        this.value = value;
        this.allComplexEventChunk = new ComplexEventChunk(false);
    }

    @Override
    public OutputRateLimiter clone(String key) {
        AllPerEventOutputRateLimiter instance = new AllPerEventOutputRateLimiter(this.id + key, this.value);
        instance.setLatencyTracker(this.latencyTracker);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ArrayList outputEventChunks = new ArrayList();
        AllPerEventOutputRateLimiter allPerEventOutputRateLimiter = this;
        synchronized (allPerEventOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() != ComplexEvent.Type.CURRENT && object.getType() != ComplexEvent.Type.EXPIRED) continue;
                complexEventChunk.remove();
                this.allComplexEventChunk.add((ComplexEvent)object);
                ++this.counter;
                if (this.counter != this.value) continue;
                ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(complexEventChunk.isBatch());
                outputEventChunk.add(this.allComplexEventChunk.getFirst());
                this.allComplexEventChunk.clear();
                this.counter = 0;
                outputEventChunks.add(outputEventChunk);
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("Counter", this.counter);
        state.put("AllComplexEventChunk", this.allComplexEventChunk.getFirst());
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.allComplexEventChunk.clear();
        this.allComplexEventChunk.add((ComplexEvent)state.get("AllComplexEventChunk"));
        this.counter = (Integer)state.get("Counter");
    }
}

