/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.event.state;

import java.util.ArrayList;
import java.util.Arrays;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;

public class StateEvent
implements ComplexEvent {
    private static final long serialVersionUID = -4298551180747630402L;
    protected StreamEvent[] streamEvents;
    protected StateEvent next;
    protected long timestamp = -1L;
    protected ComplexEvent.Type type = ComplexEvent.Type.CURRENT;
    protected Object[] outputData;
    private long id;

    public StateEvent(int streamEventsSize, int outputSize) {
        this.streamEvents = new StreamEvent[streamEventsSize];
        this.outputData = new Object[outputSize];
    }

    public StreamEvent getStreamEvent(int position) {
        return this.streamEvents[position];
    }

    public StreamEvent[] getStreamEvents() {
        return this.streamEvents;
    }

    @Override
    public StateEvent getNext() {
        return this.next;
    }

    @Override
    public void setNext(ComplexEvent stateEvent) {
        this.next = (StateEvent)stateEvent;
    }

    @Override
    public void setOutputData(Object object, int index) {
        this.outputData[index] = object;
    }

    @Override
    public Object getAttribute(int[] position) {
        if (position[2] == 3) {
            return this.outputData[position[3]];
        }
        StreamEvent streamEvent = this.getStreamEvent(position);
        if (streamEvent == null) {
            return null;
        }
        switch (position[2]) {
            case 0: {
                return streamEvent.getBeforeWindowData()[position[3]];
            }
            case 2: {
                return streamEvent.getOutputData()[position[3]];
            }
            case 1: {
                return streamEvent.getOnAfterWindowData()[position[3]];
            }
        }
        throw new IllegalStateException("STREAM_ATTRIBUTE_TYPE_INDEX cannot be " + position[2]);
    }

    @Override
    public void setAttribute(Object object, int[] position) {
        if (position[2] == 3) {
            this.outputData[position[3]] = object;
        } else {
            StreamEvent streamEvent = this.getStreamEvent(position);
            if (streamEvent == null) {
                return;
            }
            switch (position[2]) {
                case 0: {
                    streamEvent.getBeforeWindowData()[position[3]] = object;
                    break;
                }
                case 2: {
                    streamEvent.getOutputData()[position[3]] = object;
                    break;
                }
                case 1: {
                    streamEvent.getOnAfterWindowData()[position[3]] = object;
                    break;
                }
                default: {
                    throw new IllegalStateException("STREAM_ATTRIBUTE_TYPE_INDEX cannot be " + position[2]);
                }
            }
        }
    }

    public StreamEvent getStreamEvent(int[] position) {
        StreamEvent streamEvent = this.streamEvents[position[0]];
        if (streamEvent == null) {
            return null;
        }
        int streamEventIndex = position[1];
        if (streamEventIndex >= 0) {
            for (int i = 1; i <= position[1]; ++i) {
                if ((streamEvent = streamEvent.getNext()) != null) continue;
                return null;
            }
        } else if (streamEventIndex == -1) {
            while (streamEvent.getNext() != null) {
                streamEvent = streamEvent.getNext();
            }
        } else if (streamEventIndex == -2) {
            if (streamEvent.getNext() == null) {
                return null;
            }
            while (streamEvent.getNext().getNext() != null) {
                streamEvent = streamEvent.getNext();
            }
        } else {
            ArrayList<StreamEvent> stateEventList = new ArrayList<StreamEvent>();
            while (streamEvent != null) {
                stateEventList.add(streamEvent);
                streamEvent = streamEvent.getNext();
            }
            int index = stateEventList.size() + streamEventIndex;
            if (index < 0) {
                return null;
            }
            streamEvent = (StreamEvent)stateEventList.get(index);
        }
        return streamEvent;
    }

    @Override
    public Object[] getOutputData() {
        return this.outputData;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public ComplexEvent.Type getType() {
        return this.type;
    }

    @Override
    public void setType(ComplexEvent.Type type) {
        this.type = type;
    }

    public void setEvent(int position, StreamEvent streamEvent) {
        this.streamEvents[position] = streamEvent;
    }

    public void addEvent(int position, StreamEvent streamEvent) {
        StreamEvent aStreamEvent = this.streamEvents[position];
        if (aStreamEvent == null) {
            this.setEvent(position, streamEvent);
        } else {
            while (aStreamEvent.getNext() != null) {
                aStreamEvent = aStreamEvent.getNext();
            }
            aStreamEvent.setNext(streamEvent);
        }
    }

    public void removeLastEvent(int position) {
        StreamEvent aStreamEvent = this.streamEvents[position];
        if (aStreamEvent != null) {
            while (aStreamEvent.getNext() != null) {
                if (aStreamEvent.getNext().getNext() == null) {
                    aStreamEvent.setNext(null);
                    return;
                }
                aStreamEvent = aStreamEvent.getNext();
            }
            this.streamEvents[position] = null;
        }
    }

    public String toString() {
        return "StateEvent{streamEvents=" + Arrays.toString(this.streamEvents) + ", timestamp=" + this.timestamp + ", type=" + (Object)((Object)this.type) + ", outputData=" + Arrays.toString(this.outputData) + ", next=" + this.next + '}';
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }
}

