/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.timestamp;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.wso2.siddhi.core.config.SiddhiAppContext;

public class TimestampGenerator {
    private final ScheduledExecutorService scheduledExecutorService;
    private long lastEventTimestamp;
    private long lastSystemTimestamp;
    private long idleTime = -1L;
    private long incrementInMilliseconds;
    private boolean heartbeatRunning;
    private TimeInjector timeInjector = new TimeInjector();
    private List<TimeChangeListener> timeChangeListeners = new ArrayList<TimeChangeListener>();
    private SiddhiAppContext siddhiAppContext;

    public TimestampGenerator(SiddhiAppContext siddhiAppContext) {
        this.siddhiAppContext = siddhiAppContext;
        this.scheduledExecutorService = siddhiAppContext.getScheduledExecutorService();
    }

    public long currentTime() {
        if (this.siddhiAppContext.isPlayback()) {
            return this.lastEventTimestamp;
        }
        return System.currentTimeMillis();
    }

    private void notifyAfter(long duration) {
        if (!this.heartbeatRunning && this.idleTime != -1L) {
            this.scheduledExecutorService.schedule(this.timeInjector, duration, TimeUnit.MILLISECONDS);
            this.heartbeatRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentTimestamp(long timestamp) {
        if (timestamp >= this.lastEventTimestamp) {
            TimestampGenerator timestampGenerator = this;
            synchronized (timestampGenerator) {
                if (timestamp >= this.lastEventTimestamp) {
                    this.lastEventTimestamp = timestamp;
                    for (TimeChangeListener listener : this.timeChangeListeners) {
                        listener.onTimeChange(this.lastEventTimestamp);
                    }
                }
                this.lastSystemTimestamp = System.currentTimeMillis();
                this.notifyAfter(this.idleTime);
            }
        }
    }

    public void setIdleTime(long idleTime) {
        this.idleTime = idleTime;
    }

    public void setIncrementInMilliseconds(long incrementInMilliseconds) {
        this.incrementInMilliseconds = incrementInMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeChangeListener(TimeChangeListener listener) {
        TimestampGenerator timestampGenerator = this;
        synchronized (timestampGenerator) {
            this.timeChangeListeners.add(listener);
        }
    }

    public static interface TimeChangeListener {
        public void onTimeChange(long var1);
    }

    private class TimeInjector
    implements Runnable {
        private TimeInjector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currentTimestamp = System.currentTimeMillis();
            TimestampGenerator timestampGenerator = TimestampGenerator.this;
            synchronized (timestampGenerator) {
                TimestampGenerator.this.heartbeatRunning = false;
                long diff = currentTimestamp - TimestampGenerator.this.lastSystemTimestamp;
                if (diff >= TimestampGenerator.this.idleTime) {
                    long newTimestamp = TimestampGenerator.this.lastEventTimestamp + TimestampGenerator.this.incrementInMilliseconds;
                    TimestampGenerator.this.setCurrentTimestamp(newTimestamp);
                } else {
                    TimestampGenerator.this.notifyAfter(TimestampGenerator.this.idleTime - diff);
                }
            }
        }
    }
}

