/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.snapshot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.GroupedComplexEvent;
import org.wso2.siddhi.core.event.stream.StreamEventPool;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.parser.SchedulerParser;

public class AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter
extends SnapshotOutputRateLimiter {
    private final Long value;
    private final ScheduledExecutorService scheduledExecutorService;
    String queryName;
    private String id;
    private Map<String, LastEventHolder> groupByKeyEvents = new LinkedHashMap<String, LastEventHolder>();
    private Scheduler scheduler;
    private long scheduledTime;

    public AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, SiddhiAppContext siddhiAppContext, String queryName) {
        super(wrappedSnapshotOutputRateLimiter, siddhiAppContext);
        this.queryName = queryName;
        this.id = id;
        this.value = value;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public SnapshotOutputRateLimiter clone(String key, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter) {
        return new AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, wrappedSnapshotOutputRateLimiter, this.siddhiAppContext, this.queryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        ArrayList<ComplexEventChunk<ComplexEvent>> outputEventChunks = new ArrayList<ComplexEventChunk<ComplexEvent>>();
        complexEventChunk.reset();
        AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter allAggregationGroupByWindowedPerSnapshotOutputRateLimiter = this;
        synchronized (allAggregationGroupByWindowedPerSnapshotOutputRateLimiter) {
            while (complexEventChunk.hasNext()) {
                Object object = complexEventChunk.next();
                if (object.getType() == ComplexEvent.Type.TIMER) {
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)object);
                    continue;
                }
                complexEventChunk.remove();
                this.tryFlushEvents(outputEventChunks, (ComplexEvent)object);
                GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)object;
                LastEventHolder lastEventHolder = this.groupByKeyEvents.get(groupedComplexEvent.getGroupKey());
                if (lastEventHolder == null) {
                    lastEventHolder = new LastEventHolder();
                    this.groupByKeyEvents.put(groupedComplexEvent.getGroupKey(), lastEventHolder);
                }
                if (groupedComplexEvent.getType() == ComplexEvent.Type.CURRENT) {
                    lastEventHolder.addLastInEvent(groupedComplexEvent.getComplexEvent());
                    continue;
                }
                if (groupedComplexEvent.getType() == ComplexEvent.Type.EXPIRED) {
                    lastEventHolder.removeLastInEvent(groupedComplexEvent.getComplexEvent());
                    continue;
                }
                if (groupedComplexEvent.getType() != ComplexEvent.Type.RESET) continue;
                this.groupByKeyEvents.clear();
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    private void tryFlushEvents(List<ComplexEventChunk<ComplexEvent>> outputEventChunks, ComplexEvent event) {
        if (event.getTimestamp() >= this.scheduledTime) {
            ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(false);
            Iterator<Map.Entry<String, LastEventHolder>> iterator = this.groupByKeyEvents.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, LastEventHolder> lastEventHolderEntry = iterator.next();
                lastEventHolderEntry.getValue().checkAndClearLastInEvent();
                if (lastEventHolderEntry.getValue().lastEvent == null) {
                    iterator.remove();
                    continue;
                }
                outputEventChunk.add(this.cloneComplexEvent(lastEventHolderEntry.getValue().lastEvent));
            }
            outputEventChunks.add(outputEventChunk);
            this.scheduledTime += this.value.longValue();
            this.scheduler.notifyAt(this.scheduledTime);
        }
    }

    @Override
    public void start() {
        this.scheduler = SchedulerParser.parse(this.scheduledExecutorService, this, this.siddhiAppContext);
        this.scheduler.setStreamEventPool(new StreamEventPool(0, 0, 0, 5));
        this.scheduler.init(this.lockWrapper, this.queryName);
        long currentTime = System.currentTimeMillis();
        this.scheduledTime = currentTime + this.value;
        this.scheduler.notifyAt(this.scheduledTime);
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        AllAggregationGroupByWindowedPerSnapshotOutputRateLimiter allAggregationGroupByWindowedPerSnapshotOutputRateLimiter = this;
        synchronized (allAggregationGroupByWindowedPerSnapshotOutputRateLimiter) {
            state.put("GroupByKeyEvents", this.groupByKeyEvents);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.groupByKeyEvents = (Map)state.get("GroupByKeyEvents");
    }

    private class LastEventHolder {
        long count = 0L;
        ComplexEvent lastEvent = null;

        private LastEventHolder() {
        }

        public void addLastInEvent(ComplexEvent lastEvent) {
            this.lastEvent = lastEvent;
            ++this.count;
        }

        public void removeLastInEvent(ComplexEvent lastEvent) {
            this.lastEvent = lastEvent;
            --this.count;
        }

        public void checkAndClearLastInEvent() {
            if (this.count <= 0L) {
                this.lastEvent = null;
            }
        }
    }
}

