/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.output.sink.distributed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.transport.DynamicOptions;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.query.api.definition.StreamDefinition;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

public abstract class DistributionStrategy {
    static final List<Integer> EMPTY_RETURN_VALUE = new ArrayList<Integer>();
    List<Integer> destinationIds = new CopyOnWriteArrayList<Integer>();

    public abstract void init(StreamDefinition var1, OptionHolder var2, OptionHolder var3, List<OptionHolder> var4, ConfigReader var5);

    public abstract List<Integer> getDestinationsToPublish(Object var1, DynamicOptions var2);

    public void destinationFailed(Integer destinationId) {
        this.destinationIds.remove(destinationId);
    }

    public void destinationAvailable(Integer destinationId) {
        if (this.destinationIds.contains(destinationId)) {
            throw new SiddhiAppValidationException("Destination ID " + destinationId + " already registered");
        }
        this.destinationIds.add(destinationId);
        Collections.sort(this.destinationIds);
    }
}

