/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.stream.output.sink.distributed;

import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.ConnectionUnavailableException;
import org.wso2.siddhi.core.stream.output.sink.Sink;
import org.wso2.siddhi.core.stream.output.sink.SinkHandler;
import org.wso2.siddhi.core.stream.output.sink.SinkMapper;
import org.wso2.siddhi.core.stream.output.sink.distributed.DistributionStrategy;
import org.wso2.siddhi.core.util.ExceptionUtil;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.transport.DynamicOptions;
import org.wso2.siddhi.core.util.transport.OptionHolder;
import org.wso2.siddhi.query.api.annotation.Annotation;
import org.wso2.siddhi.query.api.annotation.Element;
import org.wso2.siddhi.query.api.definition.StreamDefinition;

public abstract class DistributedTransport
extends Sink {
    private static final Logger log = Logger.getLogger(DistributedTransport.class);
    protected DistributionStrategy strategy;
    protected StreamDefinition streamDefinition;
    protected SiddhiAppContext siddhiAppContext;
    private OptionHolder sinkOptionHolder;
    private String[] supportedDynamicOptions;

    @Override
    protected void init(StreamDefinition outputStreamDefinition, OptionHolder optionHolder, ConfigReader sinkConfigReader, SiddhiAppContext siddhiAppContext) {
        this.streamDefinition = outputStreamDefinition;
        this.sinkOptionHolder = optionHolder;
        this.siddhiAppContext = siddhiAppContext;
    }

    public void init(StreamDefinition streamDefinition, String type, OptionHolder transportOptionHolder, ConfigReader sinkConfigReader, SinkMapper sinkMapper, String mapType, OptionHolder mapOptionHolder, SinkHandler sinkHandler, List<Element> payloadElementList, ConfigReader mapperConfigReader, SiddhiAppContext siddhiAppContext, List<OptionHolder> destinationOptionHolders, Annotation sinkAnnotation, DistributionStrategy strategy, String[] supportedDynamicOptions) {
        this.strategy = strategy;
        this.supportedDynamicOptions = supportedDynamicOptions;
        this.init(streamDefinition, type, transportOptionHolder, sinkConfigReader, sinkMapper, mapType, mapOptionHolder, sinkHandler, payloadElementList, mapperConfigReader, siddhiAppContext);
        this.initTransport(this.sinkOptionHolder, destinationOptionHolders, sinkAnnotation, sinkConfigReader, siddhiAppContext);
    }

    @Override
    public void publish(Object payload, DynamicOptions transportOptions) throws ConnectionUnavailableException {
        int errorCount = 0;
        StringBuilder errorMessages = null;
        List<Integer> destinationsToPublish = this.strategy.getDestinationsToPublish(payload, transportOptions);
        int destinationsToPublishSize = destinationsToPublish.size();
        for (Integer destinationId : destinationsToPublish) {
            try {
                this.publish(payload, transportOptions, destinationId);
            }
            catch (ConnectionUnavailableException e) {
                ++errorCount;
                if (errorMessages == null) {
                    errorMessages = new StringBuilder();
                }
                errorMessages.append("[Destination ").append(destinationId).append("]:").append(e.getMessage());
                log.warn((Object)(ExceptionUtil.getMessageWithContext(e, this.siddhiAppContext) + " Failed to publish destination ID " + destinationId));
            }
        }
        if (errorCount > 0) {
            throw new ConnectionUnavailableException("Error on '" + this.siddhiAppContext.getName() + "'. " + errorCount + "/" + destinationsToPublishSize + " connections failed while trying to publish with following" + " error messages:" + errorMessages.toString());
        }
    }

    @Override
    public String[] getSupportedDynamicOptions() {
        return this.supportedDynamicOptions;
    }

    public abstract void publish(Object var1, DynamicOptions var2, Integer var3) throws ConnectionUnavailableException;

    public abstract void initTransport(OptionHolder var1, List<OptionHolder> var2, Annotation var3, ConfigReader var4, SiddhiAppContext var5);
}

