/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="distinctCount", namespace="", description="Returns the count of distinct occurrences for a given arg.", parameters={@Parameter(name="arg", description="The value that should be counted.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT, DataType.STRING})}, returnAttributes={@ReturnAttribute(description="Returns the count of distinct occurrences for a given arg.", type={DataType.LONG})}, examples={@Example(syntax="from fooStream\nselect distinctcount(pageID) as count\ninsert into barStream;", description="distinctcount(pageID) for the following output returns 3.\n \"WEB_PAGE_1\"\n \"WEB_PAGE_1\"\n \"WEB_PAGE_2\"\n \"WEB_PAGE_3\"\n \"WEB_PAGE_1\"\n \"WEB_PAGE_2\"")})
public class DistinctCountAttributeAggregator
extends AttributeAggregator {
    private Map<Object, Long> distinctValues = new HashMap<Object, Long>();

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Distinct count aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return Attribute.Type.LONG;
    }

    @Override
    public Object processAdd(Object data) {
        Long preVal = this.distinctValues.get(data);
        if (preVal != null) {
            preVal = preVal + 1L;
            this.distinctValues.put(data, preVal);
        } else {
            this.distinctValues.put(data, 1L);
        }
        return this.getDistinctCount();
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Distinct count aggregator cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        Long preVal;
        Long l = preVal = this.distinctValues.get(data);
        Long l2 = preVal = Long.valueOf(preVal - 1L);
        if (preVal > 0L) {
            this.distinctValues.put(data, preVal);
        } else {
            this.distinctValues.remove(data);
        }
        return this.getDistinctCount();
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Distinct count aggregator cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object reset() {
        this.distinctValues.clear();
        return this.getDistinctCount();
    }

    @Override
    public boolean canDestroy() {
        return this.distinctValues.size() == 0;
    }

    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("DistinctValues", this.distinctValues);
        return state;
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.distinctValues = (Map)state.get("DistinctValues");
    }

    private long getDistinctCount() {
        return this.distinctValues.size();
    }
}

