/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.parser;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.state.MetaStateEvent;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.input.ProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveProcessor;
import org.wso2.siddhi.core.query.input.stream.single.SingleStreamRuntime;
import org.wso2.siddhi.core.query.input.stream.state.AbsentLogicalPostStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.AbsentLogicalPreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.AbsentStreamPostStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.AbsentStreamPreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.CountPostStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.CountPreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.LogicalPostStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.LogicalPreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.StateStreamRuntime;
import org.wso2.siddhi.core.query.input.stream.state.StreamPostStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.receiver.PatternMultiProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.state.receiver.PatternSingleProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.state.receiver.SequenceMultiProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.state.receiver.SequenceSingleProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.state.runtime.CountInnerStateRuntime;
import org.wso2.siddhi.core.query.input.stream.state.runtime.EveryInnerStateRuntime;
import org.wso2.siddhi.core.query.input.stream.state.runtime.InnerStateRuntime;
import org.wso2.siddhi.core.query.input.stream.state.runtime.LogicalInnerStateRuntime;
import org.wso2.siddhi.core.query.input.stream.state.runtime.NextInnerStateRuntime;
import org.wso2.siddhi.core.query.input.stream.state.runtime.StreamInnerStateRuntime;
import org.wso2.siddhi.core.query.processor.SchedulingProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.parser.SchedulerParser;
import org.wso2.siddhi.core.util.parser.SingleInputStreamParser;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.execution.query.input.state.AbsentStreamStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.CountStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.EveryStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.NextStateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StateElement;
import org.wso2.siddhi.query.api.execution.query.input.state.StreamStateElement;
import org.wso2.siddhi.query.api.execution.query.input.stream.BasicSingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.SingleInputStream;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;

public class StateInputStreamParser {
    public static StateStreamRuntime parseInputStream(StateInputStream stateInputStream, SiddhiAppContext siddhiAppContext, MetaStateEvent metaStateEvent, Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, AbstractDefinition> aggregationDefinitionMap, Map<String, Table> tableMap, List<VariableExpressionExecutor> variableExpressionExecutors, LatencyTracker latencyTracker, String queryName) {
        HashMap<String, ProcessStreamReceiver> processStreamReceiverMap = new HashMap<String, ProcessStreamReceiver>();
        StateStreamRuntime stateStreamRuntime = new StateStreamRuntime(siddhiAppContext, metaStateEvent);
        String defaultLockKey = "";
        for (String streamId : stateInputStream.getAllStreamIds()) {
            int streamCount = stateInputStream.getStreamCount(streamId);
            if (streamCount == 1) {
                if (stateInputStream.getStateType() == StateInputStream.Type.SEQUENCE) {
                    processStreamReceiverMap.put(streamId, new SequenceSingleProcessStreamReceiver(streamId, stateStreamRuntime, defaultLockKey, latencyTracker, queryName, siddhiAppContext));
                    continue;
                }
                processStreamReceiverMap.put(streamId, new PatternSingleProcessStreamReceiver(streamId, defaultLockKey, latencyTracker, queryName, siddhiAppContext));
                continue;
            }
            if (stateInputStream.getStateType() == StateInputStream.Type.SEQUENCE) {
                processStreamReceiverMap.put(streamId, new SequenceMultiProcessStreamReceiver(streamId, streamCount, stateStreamRuntime, latencyTracker, queryName, siddhiAppContext));
                continue;
            }
            processStreamReceiverMap.put(streamId, new PatternMultiProcessStreamReceiver(streamId, streamCount, latencyTracker, queryName, siddhiAppContext));
        }
        StateElement stateElement = stateInputStream.getStateElement();
        InnerStateRuntime innerStateRuntime = StateInputStreamParser.parse(stateElement, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, tableMap, metaStateEvent, siddhiAppContext, variableExpressionExecutors, processStreamReceiverMap, null, null, stateInputStream.getStateType(), new ArrayList<Map.Entry<Long, Set<Integer>>>(), latencyTracker, queryName);
        stateStreamRuntime.setInnerStateRuntime(innerStateRuntime);
        ((StreamPreStateProcessor)innerStateRuntime.getFirstProcessor()).setThisLastProcessor((StreamPostStateProcessor)innerStateRuntime.getLastProcessor());
        return stateStreamRuntime;
    }

    private static InnerStateRuntime parse(StateElement stateElement, Map<String, AbstractDefinition> streamDefinitionMap, Map<String, AbstractDefinition> tableDefinitionMap, Map<String, AbstractDefinition> windowDefinitionMap, Map<String, AbstractDefinition> aggregationDefinitionMap, Map<String, Table> tableMap, MetaStateEvent metaStateEvent, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, ProcessStreamReceiver> processStreamReceiverMap, StreamPreStateProcessor streamPreStateProcessor, StreamPostStateProcessor streamPostStateProcessor, StateInputStream.Type stateType, ArrayList<Map.Entry<Long, Set<Integer>>> withinStates, LatencyTracker latencyTracker, String queryName) {
        if (stateElement instanceof StreamStateElement) {
            BasicSingleInputStream basicSingleInputStream = ((StreamStateElement)stateElement).getBasicSingleInputStream();
            SingleStreamRuntime singleStreamRuntime = SingleInputStreamParser.parseInputStream((SingleInputStream)basicSingleInputStream, siddhiAppContext, variableExpressionExecutors, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, tableMap, metaStateEvent, processStreamReceiverMap.get(basicSingleInputStream.getUniqueStreamIds().get(0)), false, false, queryName);
            int stateIndex = metaStateEvent.getStreamEventCount() - 1;
            if (streamPreStateProcessor == null) {
                if (stateElement.getWithin() != null) {
                    HashSet<Integer> withinStateset = new HashSet<Integer>();
                    withinStateset.add(-1);
                    withinStates.add(0, new AbstractMap.SimpleEntry(stateElement.getWithin().getValue(), withinStateset));
                }
                if (stateElement instanceof AbsentStreamStateElement) {
                    AbsentStreamPreStateProcessor absentProcessor = new AbsentStreamPreStateProcessor(stateType, StateInputStreamParser.clonewithinStates(withinStates), ((AbsentStreamStateElement)stateElement).getWaitingTime());
                    siddhiAppContext.addEternalReferencedHolder(absentProcessor);
                    EntryValveProcessor entryValveProcessor = new EntryValveProcessor(siddhiAppContext);
                    entryValveProcessor.setToLast(absentProcessor);
                    Scheduler scheduler = SchedulerParser.parse(siddhiAppContext.getScheduledExecutorService(), entryValveProcessor, siddhiAppContext);
                    absentProcessor.setScheduler(scheduler);
                    streamPreStateProcessor = absentProcessor;
                } else {
                    streamPreStateProcessor = new StreamPreStateProcessor(stateType, StateInputStreamParser.clonewithinStates(withinStates));
                }
                streamPreStateProcessor.init(siddhiAppContext, queryName);
                if (stateElement.getWithin() != null) {
                    withinStates.remove(0);
                }
            }
            streamPreStateProcessor.setStateId(stateIndex);
            streamPreStateProcessor.setNextProcessor(singleStreamRuntime.getProcessorChain());
            singleStreamRuntime.setProcessorChain(streamPreStateProcessor);
            if (streamPostStateProcessor == null) {
                streamPostStateProcessor = stateElement instanceof AbsentStreamStateElement ? new AbsentStreamPostStateProcessor() : new StreamPostStateProcessor();
            }
            streamPostStateProcessor.setStateId(stateIndex);
            singleStreamRuntime.getProcessorChain().setToLast(streamPostStateProcessor);
            streamPostStateProcessor.setThisStatePreProcessor(streamPreStateProcessor);
            streamPreStateProcessor.setThisStatePostProcessor(streamPostStateProcessor);
            streamPreStateProcessor.setThisLastProcessor(streamPostStateProcessor);
            StreamInnerStateRuntime innerStateRuntime = new StreamInnerStateRuntime(stateType);
            innerStateRuntime.setFirstProcessor(streamPreStateProcessor);
            innerStateRuntime.setLastProcessor(streamPostStateProcessor);
            innerStateRuntime.addStreamRuntime(singleStreamRuntime);
            return innerStateRuntime;
        }
        if (stateElement instanceof NextStateElement) {
            StateElement currentElement = ((NextStateElement)stateElement).getStateElement();
            InnerStateRuntime currentInnerStateRuntime = StateInputStreamParser.parse(currentElement, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, tableMap, metaStateEvent, siddhiAppContext, variableExpressionExecutors, processStreamReceiverMap, streamPreStateProcessor, streamPostStateProcessor, stateType, withinStates, latencyTracker, queryName);
            if (stateElement.getWithin() != null) {
                HashSet<Integer> withinStateSet = new HashSet<Integer>();
                withinStateSet.add(currentInnerStateRuntime.getFirstProcessor().getStateId());
                withinStateSet.add(currentInnerStateRuntime.getLastProcessor().getStateId());
                withinStates.add(0, new AbstractMap.SimpleEntry(stateElement.getWithin().getValue(), withinStateSet));
            }
            StateElement nextElement = ((NextStateElement)stateElement).getNextStateElement();
            InnerStateRuntime nextInnerStateRuntime = StateInputStreamParser.parse(nextElement, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, tableMap, metaStateEvent, siddhiAppContext, variableExpressionExecutors, processStreamReceiverMap, streamPreStateProcessor, streamPostStateProcessor, stateType, withinStates, latencyTracker, queryName);
            if (stateElement.getWithin() != null) {
                withinStates.remove(0);
            }
            currentInnerStateRuntime.getLastProcessor().setNextStatePreProcessor(nextInnerStateRuntime.getFirstProcessor());
            NextInnerStateRuntime nextStateRuntime = new NextInnerStateRuntime(currentInnerStateRuntime, nextInnerStateRuntime, stateType);
            nextStateRuntime.setFirstProcessor(currentInnerStateRuntime.getFirstProcessor());
            nextStateRuntime.setLastProcessor(nextInnerStateRuntime.getLastProcessor());
            for (SingleStreamRuntime singleStreamRuntime : currentInnerStateRuntime.getSingleStreamRuntimeList()) {
                nextStateRuntime.addStreamRuntime(singleStreamRuntime);
            }
            for (SingleStreamRuntime singleStreamRuntime : nextInnerStateRuntime.getSingleStreamRuntimeList()) {
                nextStateRuntime.addStreamRuntime(singleStreamRuntime);
            }
            return nextStateRuntime;
        }
        if (stateElement instanceof EveryStateElement) {
            StateElement currentElement = ((EveryStateElement)stateElement).getStateElement();
            InnerStateRuntime innerStateRuntime = StateInputStreamParser.parse(currentElement, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, tableMap, metaStateEvent, siddhiAppContext, variableExpressionExecutors, processStreamReceiverMap, streamPreStateProcessor, streamPostStateProcessor, stateType, withinStates, latencyTracker, queryName);
            EveryInnerStateRuntime everyInnerStateRuntime = new EveryInnerStateRuntime(innerStateRuntime, stateType);
            everyInnerStateRuntime.setFirstProcessor(innerStateRuntime.getFirstProcessor());
            everyInnerStateRuntime.setLastProcessor(innerStateRuntime.getLastProcessor());
            for (SingleStreamRuntime singleStreamRuntime : innerStateRuntime.getSingleStreamRuntimeList()) {
                everyInnerStateRuntime.addStreamRuntime(singleStreamRuntime);
            }
            everyInnerStateRuntime.getLastProcessor().setNextEveryStatePerProcessor(everyInnerStateRuntime.getFirstProcessor());
            return everyInnerStateRuntime;
        }
        if (stateElement instanceof LogicalStateElement) {
            LogicalPreStateProcessor logicalPreStateProcessor2;
            LogicalPreStateProcessor logicalPreStateProcessor1;
            LogicalStateElement.Type type = ((LogicalStateElement)stateElement).getType();
            if (stateElement.getWithin() != null) {
                HashSet<Integer> withinStateset = new HashSet<Integer>();
                withinStateset.add(-1);
                withinStates.add(0, new AbstractMap.SimpleEntry(stateElement.getWithin().getValue(), withinStateset));
            }
            if (((LogicalStateElement)stateElement).getStreamStateElement1() instanceof AbsentStreamStateElement) {
                logicalPreStateProcessor1 = new AbsentLogicalPreStateProcessor(type, stateType, StateInputStreamParser.clonewithinStates(withinStates), ((AbsentStreamStateElement)((LogicalStateElement)stateElement).getStreamStateElement1()).getWaitingTime());
                siddhiAppContext.addEternalReferencedHolder((AbsentLogicalPreStateProcessor)logicalPreStateProcessor1);
                EntryValveProcessor entryValveProcessor = new EntryValveProcessor(siddhiAppContext);
                entryValveProcessor.setToLast(logicalPreStateProcessor1);
                Scheduler scheduler = SchedulerParser.parse(siddhiAppContext.getScheduledExecutorService(), entryValveProcessor, siddhiAppContext);
                ((SchedulingProcessor)((Object)logicalPreStateProcessor1)).setScheduler(scheduler);
            } else {
                logicalPreStateProcessor1 = new LogicalPreStateProcessor(type, stateType, StateInputStreamParser.clonewithinStates(withinStates));
            }
            logicalPreStateProcessor1.init(siddhiAppContext, queryName);
            LogicalPostStateProcessor logicalPostStateProcessor1 = ((LogicalStateElement)stateElement).getStreamStateElement1() instanceof AbsentStreamStateElement ? new AbsentLogicalPostStateProcessor(type) : new LogicalPostStateProcessor(type);
            if (((LogicalStateElement)stateElement).getStreamStateElement2() instanceof AbsentStreamStateElement) {
                logicalPreStateProcessor2 = new AbsentLogicalPreStateProcessor(type, stateType, StateInputStreamParser.clonewithinStates(withinStates), ((AbsentStreamStateElement)((LogicalStateElement)stateElement).getStreamStateElement2()).getWaitingTime());
                siddhiAppContext.addEternalReferencedHolder((AbsentLogicalPreStateProcessor)logicalPreStateProcessor2);
                EntryValveProcessor entryValveProcessor = new EntryValveProcessor(siddhiAppContext);
                entryValveProcessor.setToLast(logicalPreStateProcessor2);
                Scheduler scheduler = SchedulerParser.parse(siddhiAppContext.getScheduledExecutorService(), entryValveProcessor, siddhiAppContext);
                ((SchedulingProcessor)((Object)logicalPreStateProcessor2)).setScheduler(scheduler);
            } else {
                logicalPreStateProcessor2 = new LogicalPreStateProcessor(type, stateType, StateInputStreamParser.clonewithinStates(withinStates));
            }
            logicalPreStateProcessor2.init(siddhiAppContext, queryName);
            LogicalPostStateProcessor logicalPostStateProcessor2 = ((LogicalStateElement)stateElement).getStreamStateElement2() instanceof AbsentStreamStateElement ? new AbsentLogicalPostStateProcessor(type) : new LogicalPostStateProcessor(type);
            if (stateElement.getWithin() != null) {
                withinStates.remove(0);
            }
            logicalPostStateProcessor1.setPartnerPreStateProcessor(logicalPreStateProcessor2);
            logicalPostStateProcessor2.setPartnerPreStateProcessor(logicalPreStateProcessor1);
            logicalPostStateProcessor1.setPartnerPostStateProcessor(logicalPostStateProcessor2);
            logicalPostStateProcessor2.setPartnerPostStateProcessor(logicalPostStateProcessor1);
            logicalPreStateProcessor1.setPartnerStatePreProcessor(logicalPreStateProcessor2);
            logicalPreStateProcessor2.setPartnerStatePreProcessor(logicalPreStateProcessor1);
            StreamStateElement stateElement2 = ((LogicalStateElement)stateElement).getStreamStateElement2();
            InnerStateRuntime innerStateRuntime2 = StateInputStreamParser.parse((StateElement)stateElement2, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, tableMap, metaStateEvent, siddhiAppContext, variableExpressionExecutors, processStreamReceiverMap, logicalPreStateProcessor2, logicalPostStateProcessor2, stateType, withinStates, latencyTracker, queryName);
            StreamStateElement stateElement1 = ((LogicalStateElement)stateElement).getStreamStateElement1();
            InnerStateRuntime innerStateRuntime1 = StateInputStreamParser.parse((StateElement)stateElement1, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, tableMap, metaStateEvent, siddhiAppContext, variableExpressionExecutors, processStreamReceiverMap, logicalPreStateProcessor1, logicalPostStateProcessor1, stateType, withinStates, latencyTracker, queryName);
            LogicalInnerStateRuntime logicalInnerStateRuntime = new LogicalInnerStateRuntime(innerStateRuntime1, innerStateRuntime2, stateType);
            logicalInnerStateRuntime.setFirstProcessor(innerStateRuntime1.getFirstProcessor());
            logicalInnerStateRuntime.setLastProcessor(innerStateRuntime2.getLastProcessor());
            for (SingleStreamRuntime singleStreamRuntime : innerStateRuntime2.getSingleStreamRuntimeList()) {
                logicalInnerStateRuntime.addStreamRuntime(singleStreamRuntime);
            }
            for (SingleStreamRuntime singleStreamRuntime : innerStateRuntime1.getSingleStreamRuntimeList()) {
                logicalInnerStateRuntime.addStreamRuntime(singleStreamRuntime);
            }
            return logicalInnerStateRuntime;
        }
        if (stateElement instanceof CountStateElement) {
            int minCount = ((CountStateElement)stateElement).getMinCount();
            int maxCount = ((CountStateElement)stateElement).getMaxCount();
            if (minCount == -1) {
                minCount = 0;
            }
            if (maxCount == -1) {
                maxCount = Integer.MAX_VALUE;
            }
            if (stateElement.getWithin() != null) {
                HashSet<Integer> withinStateset = new HashSet<Integer>();
                withinStateset.add(-1);
                withinStates.add(0, new AbstractMap.SimpleEntry(stateElement.getWithin().getValue(), withinStateset));
            }
            CountPreStateProcessor countPreStateProcessor = new CountPreStateProcessor(minCount, maxCount, stateType, withinStates);
            countPreStateProcessor.init(siddhiAppContext, queryName);
            CountPostStateProcessor countPostStateProcessor = new CountPostStateProcessor(minCount, maxCount);
            if (stateElement.getWithin() != null) {
                withinStates.remove(0);
            }
            countPreStateProcessor.setCountPostStateProcessor(countPostStateProcessor);
            StreamStateElement currentElement = ((CountStateElement)stateElement).getStreamStateElement();
            InnerStateRuntime innerStateRuntime = StateInputStreamParser.parse((StateElement)currentElement, streamDefinitionMap, tableDefinitionMap, windowDefinitionMap, aggregationDefinitionMap, tableMap, metaStateEvent, siddhiAppContext, variableExpressionExecutors, processStreamReceiverMap, countPreStateProcessor, countPostStateProcessor, stateType, withinStates, latencyTracker, queryName);
            return new CountInnerStateRuntime((StreamInnerStateRuntime)innerStateRuntime);
        }
        throw new OperationNotSupportedException();
    }

    private static List<Map.Entry<Long, Set<Integer>>> clonewithinStates(List<Map.Entry<Long, Set<Integer>>> withinStates) {
        ArrayList<Map.Entry<Long, Set<Integer>>> clonedwithinStates = new ArrayList<Map.Entry<Long, Set<Integer>>>(withinStates.size());
        for (Map.Entry<Long, Set<Integer>> entry : withinStates) {
            clonedwithinStates.add(new AbstractMap.SimpleEntry(entry.getKey(), new HashSet(entry.getValue())));
        }
        return clonedwithinStates;
    }
}

