/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.collection.executor;

import java.util.Collection;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.table.holder.IndexedEventHolder;
import org.wso2.siddhi.core.util.collection.executor.CollectionExecutor;
import org.wso2.siddhi.query.api.expression.condition.Compare;

public class CompareCollectionExecutor
implements CollectionExecutor {
    private final String attribute;
    private final Compare.Operator operator;
    private final ExpressionExecutor valueExpressionExecutor;
    private ExpressionExecutor expressionExecutor;
    private int storeEventIndex;

    public CompareCollectionExecutor(ExpressionExecutor expressionExecutor, int storeEventIndex, String attribute, Compare.Operator operator, ExpressionExecutor valueExpressionExecutor) {
        this.expressionExecutor = expressionExecutor;
        this.storeEventIndex = storeEventIndex;
        this.attribute = attribute;
        this.operator = operator;
        this.valueExpressionExecutor = valueExpressionExecutor;
    }

    @Override
    public StreamEvent find(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder, StreamEventCloner storeEventCloner) {
        ComplexEventChunk<StreamEvent> returnEventChunk = new ComplexEventChunk<StreamEvent>(false);
        Collection<StreamEvent> storeEventSet = this.findEvents(matchingEvent, indexedEventHolder);
        if (storeEventSet == null) {
            Collection<StreamEvent> storeEvents = indexedEventHolder.getAllEvents();
            for (StreamEvent storeEvent : storeEvents) {
                matchingEvent.setEvent(this.storeEventIndex, storeEvent);
                if (((Boolean)this.expressionExecutor.execute(matchingEvent)).booleanValue()) {
                    if (storeEventCloner != null) {
                        returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
                    } else {
                        returnEventChunk.add(storeEvent);
                    }
                }
                matchingEvent.setEvent(this.storeEventIndex, null);
            }
            return (StreamEvent)returnEventChunk.getFirst();
        }
        for (StreamEvent storeEvent : storeEventSet) {
            if (storeEventCloner != null) {
                returnEventChunk.add(storeEventCloner.copyStreamEvent(storeEvent));
                continue;
            }
            returnEventChunk.add(storeEvent);
        }
        return (StreamEvent)returnEventChunk.getFirst();
    }

    @Override
    public Collection<StreamEvent> findEvents(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        if (this.operator == Compare.Operator.NOT_EQUAL) {
            return null;
        }
        return indexedEventHolder.findEvents(this.attribute, this.operator, this.valueExpressionExecutor.execute(matchingEvent));
    }

    @Override
    public boolean contains(StateEvent matchingEvent, IndexedEventHolder indexedEventHolder) {
        return indexedEventHolder.containsEventSet(this.attribute, this.operator, this.valueExpressionExecutor.execute(matchingEvent));
    }

    @Override
    public void delete(StateEvent deletingEvent, IndexedEventHolder indexedEventHolder) {
        indexedEventHolder.delete(this.attribute, this.operator, this.valueExpressionExecutor.execute(deletingEvent));
    }

    @Override
    public CollectionExecutor.Cost getDefaultCost() {
        if (this.operator == Compare.Operator.EQUAL) {
            return CollectionExecutor.Cost.SINGLE_RETURN_INDEX_MATCHING;
        }
        if (this.operator == Compare.Operator.NOT_EQUAL) {
            return CollectionExecutor.Cost.EXHAUSTIVE;
        }
        return CollectionExecutor.Cost.MULTI_RETURN_INDEX_MATCHING;
    }
}

