/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query;

import java.util.ArrayList;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.exception.StoreQueryRuntimeException;
import org.wso2.siddhi.core.query.StoreQueryRuntime;
import org.wso2.siddhi.core.query.processor.stream.window.QueryableProcessor;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.CompiledSelection;

public class SelectStoreQueryRuntime
implements StoreQueryRuntime {
    private final CompiledSelection compiledSelection;
    private final CompiledCondition compiledCondition;
    private final String queryName;
    private QueryableProcessor queryableProcessor;

    public SelectStoreQueryRuntime(QueryableProcessor queryableProcessor, CompiledCondition compiledCondition, CompiledSelection compiledSelection, String queryName) {
        this.queryableProcessor = queryableProcessor;
        this.compiledCondition = compiledCondition;
        this.compiledSelection = compiledSelection;
        this.queryName = queryName;
    }

    @Override
    public Event[] execute() {
        try {
            StreamEvent streamEvents;
            StateEvent stateEvent = new StateEvent(1, 0);
            if (streamEvents == null) {
                return null;
            }
            ArrayList<Event> events = new ArrayList<Event>();
            for (streamEvents = this.queryableProcessor.query(stateEvent, this.compiledCondition, this.compiledSelection); streamEvents != null; streamEvents = streamEvents.getNext()) {
                events.add(new Event(streamEvents.getTimestamp(), streamEvents.getOutputData()));
            }
            return events.toArray(new Event[0]);
        }
        catch (Throwable t) {
            throw new StoreQueryRuntimeException("Error executing '" + this.queryName + "', " + t.getMessage(), t);
        }
    }

    @Override
    public void reset() {
    }
}

