/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.output.ratelimit.snapshot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.GroupedComplexEvent;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.AggregationWindowedPerSnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.SnapshotOutputRateLimiter;
import org.wso2.siddhi.core.query.output.ratelimit.snapshot.WrappedSnapshotOutputRateLimiter;

public class AggregationGroupByWindowedPerSnapshotOutputRateLimiter
extends AggregationWindowedPerSnapshotOutputRateLimiter {
    private List<GroupedComplexEvent> eventList;
    private Map<String, Map<Integer, Object>> groupByAggregateAttributeValueMap;

    protected AggregationGroupByWindowedPerSnapshotOutputRateLimiter(String id, Long value, ScheduledExecutorService scheduledExecutorService, List<Integer> aggregateAttributePositionList, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter, SiddhiAppContext siddhiAppContext, String queryName) {
        super(id, value, scheduledExecutorService, aggregateAttributePositionList, wrappedSnapshotOutputRateLimiter, siddhiAppContext, queryName);
        this.queryName = queryName;
        this.groupByAggregateAttributeValueMap = new HashMap<String, Map<Integer, Object>>();
        this.eventList = new LinkedList<GroupedComplexEvent>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        complexEventChunk.reset();
        ArrayList<ComplexEventChunk<ComplexEvent>> outputEventChunks = new ArrayList<ComplexEventChunk<ComplexEvent>>();
        AggregationGroupByWindowedPerSnapshotOutputRateLimiter aggregationGroupByWindowedPerSnapshotOutputRateLimiter = this;
        synchronized (aggregationGroupByWindowedPerSnapshotOutputRateLimiter) {
            complexEventChunk.reset();
            Object var4_4 = null;
            Map<Integer, Object> currentAggregateAttributeValueMap = null;
            block3: while (complexEventChunk.hasNext()) {
                String string;
                void var4_5;
                Object event = complexEventChunk.next();
                if (event.getType() == ComplexEvent.Type.TIMER) {
                    this.tryFlushEvents(outputEventChunks, (ComplexEvent)event);
                    continue;
                }
                complexEventChunk.remove();
                this.tryFlushEvents(outputEventChunks, (ComplexEvent)event);
                GroupedComplexEvent groupedComplexEvent = (GroupedComplexEvent)event;
                if (!(var4_5 != null && var4_5.equals(groupedComplexEvent.getGroupKey()) || (currentAggregateAttributeValueMap = this.groupByAggregateAttributeValueMap.get(string = groupedComplexEvent.getGroupKey())) != null)) {
                    currentAggregateAttributeValueMap = new HashMap<Integer, Object>(this.aggregateAttributePositionList.size());
                    this.groupByAggregateAttributeValueMap.put(string, currentAggregateAttributeValueMap);
                }
                if (groupedComplexEvent.getType() == ComplexEvent.Type.CURRENT) {
                    this.eventList.add(groupedComplexEvent);
                    for (Integer position : this.aggregateAttributePositionList) {
                        currentAggregateAttributeValueMap.put(position, event.getOutputData()[position]);
                    }
                    continue;
                }
                if (groupedComplexEvent.getType() == ComplexEvent.Type.EXPIRED) {
                    Iterator<GroupedComplexEvent> iterator = this.eventList.iterator();
                    while (iterator.hasNext()) {
                        GroupedComplexEvent currentEvent = iterator.next();
                        if (this.comparator.compare(currentEvent.getComplexEvent(), groupedComplexEvent.getComplexEvent()) != 0) continue;
                        iterator.remove();
                        for (Integer position : this.aggregateAttributePositionList) {
                            currentAggregateAttributeValueMap.put(position, groupedComplexEvent.getOutputData()[position]);
                        }
                        continue block3;
                    }
                    continue;
                }
                if (groupedComplexEvent.getType() != ComplexEvent.Type.RESET) continue;
                this.eventList.clear();
                this.groupByAggregateAttributeValueMap.clear();
            }
        }
        for (ComplexEventChunk complexEventChunk2 : outputEventChunks) {
            this.sendToCallBacks(complexEventChunk2);
        }
    }

    private void tryFlushEvents(List<ComplexEventChunk<ComplexEvent>> outputEventChunks, ComplexEvent event) {
        if (event.getTimestamp() >= this.scheduledTime) {
            this.constructOutputChunk(outputEventChunks);
            this.scheduledTime += this.value.longValue();
            this.scheduler.notifyAt(this.scheduledTime);
        }
    }

    private void constructOutputChunk(List<ComplexEventChunk<ComplexEvent>> outputEventChunks) {
        ComplexEventChunk<ComplexEvent> outputEventChunk = new ComplexEventChunk<ComplexEvent>(false);
        for (GroupedComplexEvent originalComplexEvent : this.eventList) {
            String currentGroupByKey = originalComplexEvent.getGroupKey();
            Map<Integer, Object> currentAggregateAttributeValueMap = this.groupByAggregateAttributeValueMap.get(currentGroupByKey);
            ComplexEvent eventCopy = this.cloneComplexEvent(originalComplexEvent.getComplexEvent());
            for (Integer position : this.aggregateAttributePositionList) {
                eventCopy.getOutputData()[position.intValue()] = currentAggregateAttributeValueMap.get(position);
            }
            outputEventChunk.add(eventCopy);
        }
        outputEventChunks.add(outputEventChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        AggregationGroupByWindowedPerSnapshotOutputRateLimiter aggregationGroupByWindowedPerSnapshotOutputRateLimiter = this;
        synchronized (aggregationGroupByWindowedPerSnapshotOutputRateLimiter) {
            state.put("EventList", this.eventList);
            state.put("GroupByAggregateAttributeValueMap", this.groupByAggregateAttributeValueMap);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        this.eventList = (List)state.get("EventList");
        this.groupByAggregateAttributeValueMap = (Map)state.get("GroupByAggregateAttributeValueMap");
    }

    @Override
    public SnapshotOutputRateLimiter clone(String key, WrappedSnapshotOutputRateLimiter wrappedSnapshotOutputRateLimiter) {
        return new AggregationGroupByWindowedPerSnapshotOutputRateLimiter(this.id + key, this.value, this.scheduledExecutorService, this.aggregateAttributePositionList, wrappedSnapshotOutputRateLimiter, this.siddhiAppContext, this.queryName);
    }
}

