/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input.stream.state;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.query.input.stream.single.EntryValveProcessor;
import org.wso2.siddhi.core.query.input.stream.state.AbsentPreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.LogicalPreStateProcessor;
import org.wso2.siddhi.core.query.input.stream.state.PreStateProcessor;
import org.wso2.siddhi.core.util.Scheduler;
import org.wso2.siddhi.core.util.parser.SchedulerParser;
import org.wso2.siddhi.query.api.execution.query.input.state.LogicalStateElement;
import org.wso2.siddhi.query.api.execution.query.input.stream.StateInputStream;
import org.wso2.siddhi.query.api.expression.constant.TimeConstant;

public class AbsentLogicalPreStateProcessor
extends LogicalPreStateProcessor
implements AbsentPreStateProcessor {
    private Scheduler scheduler;
    private long waitingTime = -1L;
    private volatile long lastArrivalTime;
    private ReentrantLock lock;
    private boolean active = true;
    private TimeConstant waitingTimeConstant;

    public AbsentLogicalPreStateProcessor(LogicalStateElement.Type type, StateInputStream.Type stateType, List<Map.Entry<Long, Set<Integer>>> withinStates, TimeConstant waitingTime) {
        super(type, stateType, withinStates);
        if (waitingTime != null) {
            this.waitingTime = waitingTime.value();
            this.waitingTimeConstant = waitingTime;
        }
    }

    @Override
    public void setPartnerStatePreProcessor(LogicalPreStateProcessor partnerStatePreProcessor) {
        super.setPartnerStatePreProcessor(partnerStatePreProcessor);
        if (this.lock == null) {
            this.lock = new ReentrantLock();
        }
        if (partnerStatePreProcessor instanceof AbsentLogicalPreStateProcessor && ((AbsentLogicalPreStateProcessor)partnerStatePreProcessor).lock == null) {
            ((AbsentLogicalPreStateProcessor)partnerStatePreProcessor).lock = this.lock;
        }
    }

    @Override
    public void updateLastArrivalTime(long timestamp) {
        this.lock.lock();
        try {
            this.lastArrivalTime = timestamp;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addState(StateEvent stateEvent) {
        if (!this.active) {
            return;
        }
        this.lock.lock();
        try {
            super.addState(stateEvent);
            if (!this.isStartState && this.waitingTime != -1L) {
                this.scheduler.notifyAt(stateEvent.getTimestamp() + this.waitingTime);
                if (this.partnerStatePreProcessor instanceof AbsentLogicalPreStateProcessor) {
                    ((AbsentLogicalPreStateProcessor)this.partnerStatePreProcessor).scheduler.notifyAt(stateEvent.getTimestamp() + ((AbsentLogicalPreStateProcessor)this.partnerStatePreProcessor).waitingTime);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void addEveryState(StateEvent stateEvent) {
        StateEvent clonedEvent = this.stateEventCloner.copyStateEvent(stateEvent);
        if (clonedEvent.getStreamEvent(this.stateId) != null) {
            clonedEvent.setTimestamp(clonedEvent.getStreamEvent(this.stateId).getTimestamp());
        }
        clonedEvent.setEvent(this.stateId, null);
        clonedEvent.setEvent(this.partnerStatePreProcessor.stateId, null);
        this.newAndEveryStateEventList.add(clonedEvent);
        this.partnerStatePreProcessor.newAndEveryStateEventList.add(clonedEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(ComplexEventChunk complexEventChunk) {
        if (!this.active) {
            return;
        }
        this.lock.lock();
        boolean notProcessed = true;
        try {
            long currentTime = complexEventChunk.getFirst().getTimestamp();
            if (currentTime >= this.lastArrivalTime + this.waitingTime) {
                StateEvent stateEvent;
                ComplexEventChunk<StateEvent> retEventChunk = new ComplexEventChunk<StateEvent>(false);
                if (this.isStartState && this.stateType == StateInputStream.Type.SEQUENCE && this.newAndEveryStateEventList.isEmpty() && this.pendingStateEventList.isEmpty()) {
                    stateEvent = this.stateEventPool.borrowEvent();
                    this.addState(stateEvent);
                } else if (this.stateType == StateInputStream.Type.SEQUENCE && !this.newAndEveryStateEventList.isEmpty()) {
                    this.resetState();
                }
                this.updateState();
                Iterator iterator = this.pendingStateEventList.iterator();
                while (iterator.hasNext()) {
                    stateEvent = (StateEvent)iterator.next();
                    if (this.withinStates.size() > 0 && this.isExpired(stateEvent, currentTime)) {
                        iterator.remove();
                        continue;
                    }
                    if (!this.waitingTimePassed(currentTime, stateEvent)) continue;
                    iterator.remove();
                    if (this.logicalType == LogicalStateElement.Type.OR && stateEvent.getStreamEvent(this.partnerStatePreProcessor.getStateId()) == null) {
                        stateEvent.addEvent(this.stateId, this.streamEventPool.borrowEvent());
                        retEventChunk.add(stateEvent);
                        continue;
                    }
                    if (this.logicalType == LogicalStateElement.Type.AND && stateEvent.getStreamEvent(this.partnerStatePreProcessor.getStateId()) != null) {
                        retEventChunk.add(stateEvent);
                        continue;
                    }
                    if (this.logicalType != LogicalStateElement.Type.AND || stateEvent.getStreamEvent(this.partnerStatePreProcessor.getStateId()) != null) continue;
                    stateEvent.addEvent(this.stateId, this.streamEventPool.borrowEvent());
                }
                retEventChunk.reset();
                boolean bl = notProcessed = retEventChunk.getFirst() == null;
                while (retEventChunk.hasNext()) {
                    stateEvent = (StateEvent)retEventChunk.next();
                    retEventChunk.remove();
                    this.sendEvent(stateEvent);
                }
                this.lastArrivalTime = 0L;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.thisStatePostProcessor.nextEveryStatePreProcessor != null || notProcessed && this.isStartState) {
            long nextBreak = this.lastArrivalTime == 0L ? this.siddhiAppContext.getTimestampGenerator().currentTime() + this.waitingTime : this.lastArrivalTime + this.waitingTime;
            this.scheduler.notifyAt(nextBreak);
        }
    }

    private boolean waitingTimePassed(long currentTime, StateEvent event) {
        if (event.getStreamEvent(this.stateId) == null) {
            return currentTime >= event.getTimestamp() + this.waitingTime;
        }
        return currentTime >= event.getStreamEvent(this.stateId).getTimestamp() + this.waitingTime;
    }

    private void sendEvent(StateEvent stateEvent) {
        if (this.thisStatePostProcessor.nextProcessor != null) {
            this.thisStatePostProcessor.nextProcessor.process(new ComplexEventChunk<StateEvent>(stateEvent, stateEvent, false));
        }
        if (this.thisStatePostProcessor.nextStatePreProcessor != null) {
            this.thisStatePostProcessor.nextStatePreProcessor.addState(stateEvent);
        }
        if (this.thisStatePostProcessor.nextEveryStatePreProcessor != null) {
            this.thisStatePostProcessor.nextEveryStatePreProcessor.addEveryState(stateEvent);
        } else if (this.isStartState) {
            this.active = false;
            if (this.logicalType == LogicalStateElement.Type.OR && this.partnerStatePreProcessor instanceof AbsentLogicalPreStateProcessor) {
                ((AbsentLogicalPreStateProcessor)this.partnerStatePreProcessor).active = false;
            }
        }
        if (this.thisStatePostProcessor.callbackPreStateProcessor != null) {
            this.thisStatePostProcessor.callbackPreStateProcessor.startStateReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComplexEventChunk<StateEvent> processAndReturn(ComplexEventChunk complexEventChunk) {
        ComplexEventChunk<StateEvent> returnEventChunk = new ComplexEventChunk<StateEvent>(false);
        if (!this.active) {
            return returnEventChunk;
        }
        complexEventChunk.reset();
        StreamEvent streamEvent = (StreamEvent)complexEventChunk.next();
        this.lock.lock();
        try {
            Iterator iterator = this.pendingStateEventList.iterator();
            while (iterator.hasNext()) {
                StateEvent stateEvent = (StateEvent)iterator.next();
                if (this.withinStates.size() > 0 && this.isExpired(stateEvent, streamEvent.getTimestamp())) {
                    iterator.remove();
                    continue;
                }
                if (this.logicalType == LogicalStateElement.Type.OR && stateEvent.getStreamEvent(this.partnerStatePreProcessor.getStateId()) != null) {
                    iterator.remove();
                    continue;
                }
                StreamEvent currentStreamEvent = stateEvent.getStreamEvent(this.stateId);
                stateEvent.setEvent(this.stateId, this.streamEventCloner.copyStreamEvent(streamEvent));
                this.process(stateEvent);
                if (this.waitingTime != -1L || this.stateType == StateInputStream.Type.SEQUENCE && this.logicalType == LogicalStateElement.Type.AND && this.thisStatePostProcessor.nextEveryStatePreProcessor != null) {
                    stateEvent.setEvent(this.stateId, currentStreamEvent);
                }
                if (this.thisLastProcessor.isEventReturned()) {
                    this.thisLastProcessor.clearProcessedEvent();
                    iterator.remove();
                    if (this.stateType == StateInputStream.Type.SEQUENCE) {
                        this.partnerStatePreProcessor.pendingStateEventList.remove(stateEvent);
                    }
                }
                if (this.stateChanged) continue;
                switch (this.stateType) {
                    case PATTERN: {
                        stateEvent.setEvent(this.stateId, currentStreamEvent);
                        break;
                    }
                    case SEQUENCE: {
                        stateEvent.setEvent(this.stateId, currentStreamEvent);
                        iterator.remove();
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return returnEventChunk;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public PreStateProcessor cloneProcessor(String key) {
        AbsentLogicalPreStateProcessor logicalPreStateProcessor = new AbsentLogicalPreStateProcessor(this.logicalType, this.stateType, this.withinStates, this.waitingTimeConstant);
        this.cloneProperties(logicalPreStateProcessor, key);
        logicalPreStateProcessor.init(this.siddhiAppContext, this.queryName);
        this.siddhiAppContext.addEternalReferencedHolder(logicalPreStateProcessor);
        EntryValveProcessor entryValveProcessor = new EntryValveProcessor(this.siddhiAppContext);
        entryValveProcessor.setToLast(logicalPreStateProcessor);
        Scheduler scheduler = SchedulerParser.parse(this.siddhiAppContext.getScheduledExecutorService(), entryValveProcessor, this.siddhiAppContext);
        logicalPreStateProcessor.setScheduler(scheduler);
        return logicalPreStateProcessor;
    }

    @Override
    public void start() {
        if (this.isStartState && this.waitingTime != -1L && this.active) {
            this.lock.lock();
            try {
                this.scheduler.notifyAt(this.siddhiAppContext.getTimestampGenerator().currentTime() + this.waitingTime);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void stop() {
    }

    public boolean partnerCanProceed(StateEvent stateEvent) {
        boolean process;
        if (this.stateType == StateInputStream.Type.SEQUENCE && this.thisStatePostProcessor.nextEveryStatePreProcessor == null && this.lastArrivalTime > 0L) {
            process = false;
        } else if (this.waitingTime == -1L) {
            if (this.thisStatePostProcessor.nextEveryStatePreProcessor == null) {
                process = stateEvent.getStreamEvent(this.stateId) == null;
            } else if (this.lastArrivalTime > 0L) {
                process = false;
                this.lastArrivalTime = 0L;
                this.init();
            } else {
                process = true;
            }
        } else {
            process = stateEvent.getStreamEvent(this.stateId) != null;
        }
        return process;
    }
}

