/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.util.event.handler;

import com.lmax.disruptor.EventHandler;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.event.Event;
import org.wso2.siddhi.core.stream.StreamJunction;
import org.wso2.siddhi.core.util.event.handler.EventExchangeHolder;

public class StreamHandler
implements EventHandler<EventExchangeHolder> {
    private List<StreamJunction.Receiver> receivers;
    private int batchSize;
    private final String streamName;
    private final String siddhiAppName;
    private List<Event> eventBuffer = new LinkedList<Event>();
    private static final Logger log = Logger.getLogger(StreamHandler.class);

    public StreamHandler(List<StreamJunction.Receiver> receivers, int batchSize, String streamName, String siddhiAppName) {
        this.receivers = receivers;
        this.batchSize = batchSize;
        this.streamName = streamName;
        this.siddhiAppName = siddhiAppName;
    }

    public void onEvent(EventExchangeHolder eventExchangeHolder, long sequence, boolean endOfBatch) {
        boolean isProcessed = eventExchangeHolder.getAndSetIsProcessed(true);
        if (!isProcessed) {
            this.eventBuffer.add(eventExchangeHolder.getEvent());
            if (this.eventBuffer.size() == this.batchSize || endOfBatch) {
                for (StreamJunction.Receiver receiver : this.receivers) {
                    try {
                        receiver.receive(this.eventBuffer);
                    }
                    catch (Throwable t) {
                        log.error((Object)("Error in SiddhiApp '" + this.siddhiAppName + "' after consuming events from Stream " + "'" + this.streamName + "', " + t.getMessage()), t);
                    }
                }
                this.eventBuffer.clear();
            }
        } else if (endOfBatch && this.eventBuffer.size() != 0) {
            for (StreamJunction.Receiver receiver : this.receivers) {
                try {
                    receiver.receive(this.eventBuffer);
                }
                catch (Throwable t) {
                    log.error((Object)("Error in SiddhiApp '" + this.siddhiAppName + "' after consuming events from Stream " + "'" + this.streamName + "', " + t.getMessage()), t);
                }
            }
            this.eventBuffer.clear();
        }
    }
}

