/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.selector.attribute.aggregator;

import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.OperationNotSupportedException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.selector.attribute.aggregator.AttributeAggregator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="max", namespace="", description="Returns the maximum value for all the events.", parameters={@Parameter(name="arg", description="The value that needs to be compared to find the maximum value.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, returnAttributes={@ReturnAttribute(description="Returns the maximum value in the same data type as the input.", type={DataType.INT, DataType.LONG, DataType.DOUBLE, DataType.FLOAT})}, examples={@Example(syntax="from fooStream#window.timeBatch(10 sec)\nselect max(temp) as maxTemp\ninsert into barStream;", description="max(temp) returns the maximum temp value recorded for all the events based on their arrival and expiry.")})
public class MaxAttributeAggregator
extends AttributeAggregator {
    private MaxAttributeAggregator maxOutputAttributeAggregator;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new OperationNotSupportedException("Max aggregator has to have exactly 1 parameter, currently " + attributeExpressionExecutors.length + " parameters provided");
        }
        Attribute.Type type = attributeExpressionExecutors[0].getReturnType();
        switch (type) {
            case FLOAT: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorFloat();
                break;
            }
            case INT: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorInt();
                break;
            }
            case LONG: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorLong();
                break;
            }
            case DOUBLE: {
                this.maxOutputAttributeAggregator = new MaxAttributeAggregatorDouble();
                break;
            }
            default: {
                throw new OperationNotSupportedException("Max not supported for " + type);
            }
        }
    }

    @Override
    public Attribute.Type getReturnType() {
        return this.maxOutputAttributeAggregator.getReturnType();
    }

    @Override
    public Object processAdd(Object data) {
        if (data == null) {
            return this.maxOutputAttributeAggregator.currentValue();
        }
        return this.maxOutputAttributeAggregator.processAdd(data);
    }

    protected Object currentValue() {
        return null;
    }

    @Override
    public Object processAdd(Object[] data) {
        return new IllegalStateException("Max cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public Object processRemove(Object data) {
        if (data == null) {
            return this.maxOutputAttributeAggregator.currentValue();
        }
        return this.maxOutputAttributeAggregator.processRemove(data);
    }

    @Override
    public Object processRemove(Object[] data) {
        return new IllegalStateException("Max cannot process data array, but found " + Arrays.deepToString(data));
    }

    @Override
    public boolean canDestroy() {
        return this.maxOutputAttributeAggregator.canDestroy();
    }

    @Override
    public Object reset() {
        return this.maxOutputAttributeAggregator.reset();
    }

    @Override
    public Map<String, Object> currentState() {
        return this.maxOutputAttributeAggregator.currentState();
    }

    @Override
    public void restoreState(Map<String, Object> state) {
        this.maxOutputAttributeAggregator.restoreState(state);
    }

    class MaxAttributeAggregatorLong
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.LONG;
        private Deque<Long> maxDeque = new LinkedList<Long>();
        private volatile Long maxValue = null;

        MaxAttributeAggregatorLong() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Long value = (Long)data;
            Iterator<Long> iterator = this.maxDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() < value) {
                iterator.remove();
            }
            this.maxDeque.addLast(value);
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.maxDeque.removeFirstOccurrence(data);
            this.maxValue = this.maxDeque.peekFirst();
            return this.maxValue;
        }

        @Override
        public synchronized Object reset() {
            this.maxDeque.clear();
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.maxDeque.size() == 0 && this.maxValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MaxAttributeAggregatorLong maxAttributeAggregatorLong = this;
            synchronized (maxAttributeAggregatorLong) {
                state.put("MaxValue", this.maxValue);
                state.put("MaxDeque", this.maxDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.maxValue = (Long)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxAttributeAggregatorInt
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.INT;
        private Deque<Integer> maxDeque = new LinkedList<Integer>();
        private volatile Integer maxValue = null;

        MaxAttributeAggregatorInt() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Integer value = (Integer)data;
            Iterator<Integer> iterator = this.maxDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() < value) {
                iterator.remove();
            }
            this.maxDeque.addLast(value);
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.maxDeque.removeFirstOccurrence(data);
            this.maxValue = this.maxDeque.peekFirst();
            return this.maxValue;
        }

        @Override
        public synchronized Object reset() {
            this.maxDeque.clear();
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.maxDeque.size() == 0 && this.maxValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MaxAttributeAggregatorInt maxAttributeAggregatorInt = this;
            synchronized (maxAttributeAggregatorInt) {
                state.put("MaxValue", this.maxValue);
                state.put("MaxDeque", this.maxDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.maxValue = (Integer)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxAttributeAggregatorFloat
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.FLOAT;
        private Deque<Float> maxDeque = new LinkedList<Float>();
        private volatile Float maxValue = null;

        MaxAttributeAggregatorFloat() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Float value = (Float)data;
            Iterator<Float> iterator = this.maxDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next().floatValue() < value.floatValue()) {
                iterator.remove();
            }
            this.maxDeque.addLast(value);
            if (this.maxValue == null || this.maxValue.floatValue() < value.floatValue()) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.maxDeque.removeFirstOccurrence(data);
            this.maxValue = this.maxDeque.peekFirst();
            return this.maxValue;
        }

        @Override
        public synchronized Object reset() {
            this.maxDeque.clear();
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.maxDeque.size() == 0 && this.maxValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MaxAttributeAggregatorFloat maxAttributeAggregatorFloat = this;
            synchronized (maxAttributeAggregatorFloat) {
                state.put("MaxValue", this.maxValue);
                state.put("MaxDeque", this.maxDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.maxValue = (Float)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }

    class MaxAttributeAggregatorDouble
    extends MaxAttributeAggregator {
        private final Attribute.Type type = Attribute.Type.DOUBLE;
        private Deque<Double> maxDeque = new LinkedList<Double>();
        private volatile Double maxValue = null;

        MaxAttributeAggregatorDouble() {
        }

        @Override
        public Attribute.Type getReturnType() {
            return this.type;
        }

        @Override
        public synchronized Object processAdd(Object data) {
            Double value = (Double)data;
            Iterator<Double> iterator = this.maxDeque.descendingIterator();
            while (iterator.hasNext() && iterator.next() < value) {
                iterator.remove();
            }
            this.maxDeque.addLast(value);
            if (this.maxValue == null || this.maxValue < value) {
                this.maxValue = value;
            }
            return this.maxValue;
        }

        @Override
        public synchronized Object processRemove(Object data) {
            this.maxDeque.removeFirstOccurrence(data);
            this.maxValue = this.maxDeque.peekFirst();
            return this.maxValue;
        }

        @Override
        public synchronized Object reset() {
            this.maxDeque.clear();
            this.maxValue = null;
            return null;
        }

        @Override
        public boolean canDestroy() {
            return this.maxDeque.size() == 0 && this.maxValue == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, Object> currentState() {
            HashMap<String, Object> state = new HashMap<String, Object>();
            MaxAttributeAggregatorDouble maxAttributeAggregatorDouble = this;
            synchronized (maxAttributeAggregatorDouble) {
                state.put("MaxValue", this.maxValue);
                state.put("MaxDeque", this.maxDeque);
            }
            return state;
        }

        @Override
        public synchronized void restoreState(Map<String, Object> state) {
            this.maxValue = (Double)state.get("MaxValue");
            this.maxDeque = (Deque)state.get("MaxDeque");
        }

        @Override
        protected Object currentValue() {
            return this.maxValue;
        }
    }
}

