/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.processor.stream.window;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.holder.SnapshotableStreamEventQueue;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.window.FindableProcessor;
import org.wso2.siddhi.core.query.processor.stream.window.WindowProcessor;
import org.wso2.siddhi.core.table.Table;
import org.wso2.siddhi.core.util.collection.operator.CompiledCondition;
import org.wso2.siddhi.core.util.collection.operator.MatchingMetaInfoHolder;
import org.wso2.siddhi.core.util.collection.operator.Operator;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.core.util.parser.OperatorParser;
import org.wso2.siddhi.core.util.snapshot.state.SnapshotStateList;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;
import org.wso2.siddhi.query.api.expression.Expression;

@Extension(name="batch", namespace="", description="A window that holds an incoming events batch. When a new set of events arrives, the previously arrived old events will be expired. Batch window can be used to aggregate events that comes in batches.", parameters={}, examples={@Example(syntax="define stream consumerItemStream (itemId string, price float)\n\nfrom consumerItemStream#window.batch()\nselect price, str:groupConcat(itemId) as itemIds\ngroup by price\ninsert into outputStream;", description="This will output comma separated items IDs that have the same price for each incoming batch of events.")})
public class BatchWindowProcessor
extends WindowProcessor
implements FindableProcessor {
    private SnapshotableStreamEventQueue expiredEventQueue = null;
    private boolean outputExpectsExpiredEvents;
    private SiddhiAppContext siddhiAppContext;
    private StreamEvent resetEvent = null;

    @Override
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, boolean outputExpectsExpiredEvents, SiddhiAppContext siddhiAppContext) {
        this.outputExpectsExpiredEvents = outputExpectsExpiredEvents;
        this.siddhiAppContext = siddhiAppContext;
        if (outputExpectsExpiredEvents) {
            this.expiredEventQueue = new SnapshotableStreamEventQueue(this.streamEventClonerHolder);
        }
        if (attributeExpressionExecutors.length != 0) {
            throw new SiddhiAppValidationException("Batch window should not have any parameters, but found " + attributeExpressionExecutors.length + " input attributes");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner) {
        ComplexEventChunk<StreamEvent> outputStreamEventChunk = new ComplexEventChunk<StreamEvent>(true);
        BatchWindowProcessor batchWindowProcessor = this;
        synchronized (batchWindowProcessor) {
            long currentTime = this.siddhiAppContext.getTimestampGenerator().currentTime();
            if (this.outputExpectsExpiredEvents && this.expiredEventQueue.getFirst() != null) {
                while (this.expiredEventQueue.hasNext()) {
                    this.expiredEventQueue.next().setTimestamp(currentTime);
                }
                outputStreamEventChunk.add(this.expiredEventQueue.getFirst());
            }
            if (this.expiredEventQueue != null) {
                this.expiredEventQueue.clear();
            }
            if (this.resetEvent != null) {
                outputStreamEventChunk.add(this.resetEvent);
            }
            while (this.outputExpectsExpiredEvents && streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                StreamEvent clonedStreamEvent = streamEventCloner.copyStreamEvent(streamEvent);
                clonedStreamEvent.setType(ComplexEvent.Type.EXPIRED);
                this.expiredEventQueue.add(clonedStreamEvent);
            }
            this.resetEvent = streamEventCloner.copyStreamEvent(streamEventChunk.getFirst());
            this.resetEvent.setType(ComplexEvent.Type.RESET);
            outputStreamEventChunk.add(streamEventChunk.getFirst());
        }
        nextProcessor.process(outputStreamEventChunk);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> currentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        BatchWindowProcessor batchWindowProcessor = this;
        synchronized (batchWindowProcessor) {
            state.put("ExpiredEventQueue", this.expiredEventQueue.getSnapshot());
            state.put("ResetEvent", this.resetEvent);
        }
        return state;
    }

    @Override
    public synchronized void restoreState(Map<String, Object> state) {
        if (this.expiredEventQueue != null) {
            this.expiredEventQueue.clear();
            this.expiredEventQueue.restore((SnapshotStateList)state.get("ExpiredEventQueue"));
        }
        this.resetEvent = (StreamEvent)state.get("ResetEvent");
    }

    @Override
    public synchronized StreamEvent find(StateEvent matchingEvent, CompiledCondition compiledCondition) {
        return ((Operator)compiledCondition).find(matchingEvent, this.expiredEventQueue, this.streamEventCloner);
    }

    @Override
    public CompiledCondition compileCondition(Expression condition, MatchingMetaInfoHolder matchingMetaInfoHolder, SiddhiAppContext siddhiAppContext, List<VariableExpressionExecutor> variableExpressionExecutors, Map<String, Table> tableMap, String queryName) {
        if (this.expiredEventQueue == null) {
            this.expiredEventQueue = new SnapshotableStreamEventQueue(this.streamEventClonerHolder);
        }
        return OperatorParser.constructOperator(this.expiredEventQueue, condition, matchingMetaInfoHolder, siddhiAppContext, variableExpressionExecutors, tableMap, this.queryName);
    }
}

