/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.core.query.input;

import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.state.StateEvent;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.query.input.ProcessStreamReceiver;
import org.wso2.siddhi.core.query.input.stream.state.StreamPreStateProcessor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.selector.QuerySelector;
import org.wso2.siddhi.core.util.statistics.LatencyTracker;

public class SingleProcessStreamReceiver
extends ProcessStreamReceiver {
    protected final String lockKey;
    protected ComplexEventChunk<StreamEvent> currentStreamEventChunk;
    protected String queryName;
    private QuerySelector querySelector;

    public SingleProcessStreamReceiver(String streamId, String lockKey, LatencyTracker latencyTracker, String queryName, SiddhiAppContext siddhiAppContext) {
        super(streamId, latencyTracker, queryName, siddhiAppContext);
        this.currentStreamEventChunk = new ComplexEventChunk(this.batchProcessingAllowed);
        this.lockKey = lockKey;
        this.queryName = queryName;
    }

    @Override
    public void setNext(Processor next) {
        super.setNext(next);
        this.querySelector = (QuerySelector)((StreamPreStateProcessor)next).getThisLastProcessor().getNextProcessor();
    }

    @Override
    public SingleProcessStreamReceiver clone(String key) {
        return new SingleProcessStreamReceiver(this.streamId + key, key, this.latencyTracker, this.queryName, this.siddhiAppContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processAndClear(ComplexEventChunk<StreamEvent> streamEventChunk) {
        ComplexEventChunk<StateEvent> retEventChunk = new ComplexEventChunk<StateEvent>(false);
        String string = this.lockKey;
        synchronized (string) {
            while (streamEventChunk.hasNext()) {
                StreamEvent streamEvent = (StreamEvent)streamEventChunk.next();
                streamEventChunk.remove();
                this.stabilizeStates();
                this.currentStreamEventChunk.add(streamEvent);
                ComplexEventChunk<StateEvent> eventChunk = ((StreamPreStateProcessor)this.next).processAndReturn(this.currentStreamEventChunk);
                if (eventChunk.getFirst() != null) {
                    retEventChunk.add(eventChunk.getFirst());
                }
                eventChunk.clear();
                this.currentStreamEventChunk.clear();
            }
        }
        while (retEventChunk.hasNext()) {
            StateEvent stateEvent = (StateEvent)retEventChunk.next();
            retEventChunk.remove();
            this.querySelector.process(new ComplexEventChunk<StateEvent>(stateEvent, stateEvent, false));
        }
    }

    protected void stabilizeStates() {
    }
}

